/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.richfaces.resource.AbstractCacheableResource;
import org.richfaces.resource.DynamicResource;
import org.richfaces.resource.StateHolderResource;

@DynamicResource
public class StateHolderResourceImpl
extends AbstractCacheableResource
implements StateHolderResource {
    private Object state = "";

    public StateHolderResourceImpl() {
        this.setResourceName(StateHolderResourceImpl.class.getName());
    }

    public InputStream getInputStream() throws IOException {
        try {
            return new ByteArrayInputStream(this.state.toString().getBytes("US-ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            throw new FacesException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isTransient() {
        return false;
    }

    public void restoreState(FacesContext context, Object state) {
        this.state = state;
    }

    public Object saveState(FacesContext context) {
        return this.state;
    }

    public void setTransient(boolean newTransientValue) {
        throw new UnsupportedOperationException();
    }

    public void readState(FacesContext context, DataInput dataInput) throws IOException {
        this.state = dataInput.readLine();
    }

    public void writeState(FacesContext context, DataOutput dataOutput) throws IOException {
        dataOutput.writeBytes(this.state.toString());
    }
}

