/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import org.junit.Assert;
import org.junit.Test;
import org.richfaces.resource.ResourceUtils;

public class ResourceUtilsTest {
    @Test
    public void testFormatWeakTag() throws Exception {
        Assert.assertNull((Object)ResourceUtils.formatWeakTag(null));
        Assert.assertEquals((Object)"W/\"123-456789\"", (Object)ResourceUtils.formatWeakTag((String)"123-456789"));
        try {
            ResourceUtils.formatWeakTag((String)"123\"456789");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testFormatTag() throws Exception {
        Assert.assertNull((Object)ResourceUtils.formatTag(null));
        Assert.assertEquals((Object)"\"123-456789\"", (Object)ResourceUtils.formatTag((String)"123-456789"));
        try {
            ResourceUtils.formatTag((String)"123\"456789");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMatchTag() throws Exception {
        Assert.assertTrue((boolean)ResourceUtils.matchTag((String)"\"123-4567890\"", (String)"W/\"123-4567890\""));
        Assert.assertTrue((boolean)ResourceUtils.matchTag((String)"\"123-4567890\"", (String)"W/\"123-4567890\", \"123-4567891\""));
        Assert.assertTrue((boolean)ResourceUtils.matchTag((String)"W/\"123-4567891\"", (String)"W/\"123-4567890\", \"123-4567891\""));
        Assert.assertFalse((boolean)ResourceUtils.matchTag((String)"\"123-4567890\"", (String)"W/\"023-4567890\""));
        Assert.assertFalse((boolean)ResourceUtils.matchTag((String)"\"123-4567890\"", (String)"W/\"023-4567890\", \"023-4567891\""));
        Assert.assertFalse((boolean)ResourceUtils.matchTag((String)"W/\"123-4567891\"", (String)"W/\"023-4567890\", \"023-4567891\""));
        try {
            ResourceUtils.matchTag(null, (String)"W/\"123-4567890\", \"123-4567891\"");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ResourceUtils.matchTag((String)"W/\"123-4567890\"", null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ResourceUtils.matchTag((String)"123\"456789", (String)"W/\"123\"");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

