/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import com.gargoylesoftware.htmlunit.html.HtmlLink;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlScript;
import java.util.Iterator;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponentBase;
import org.jboss.test.faces.htmlunit.HtmlUnitEnvironment;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.richfaces.CustomizedHtmlUnitEnvironment;
import org.w3c.dom.Element;

public class ResourceLibraryTest {
    private HtmlUnitEnvironment environment;

    private String nextUri(Iterator<?> itr) {
        Assert.assertTrue((boolean)itr.hasNext());
        Element elt = (Element)itr.next();
        if (elt instanceof HtmlScript) {
            return ((HtmlScript)elt).getSrcAttribute();
        }
        if (elt instanceof HtmlLink) {
            return ((HtmlLink)elt).getHrefAttribute();
        }
        throw new UnsupportedOperationException(elt.toString());
    }

    @Before
    public void setUp() throws Exception {
        this.environment = new CustomizedHtmlUnitEnvironment();
        this.environment.getServer().addInitParameter("org.richfaces.enableControlSkinning", "false");
        this.environment.withResource("/index.xhtml", "org/richfaces/resource/simple.xhtml");
        this.environment.start();
    }

    @After
    public void tearDown() throws Exception {
        this.environment.release();
        this.environment = null;
    }

    @Test
    public void testStaticLibrary() throws Exception {
        this.environment.getApplication().addComponent("testComponent", StaticLibraryComponent.class.getName());
        HtmlPage page = (HtmlPage)this.environment.getPage("/index.jsf");
        Iterator itr = page.getByXPath("//head/link | //head/script").iterator();
        String uri = this.nextUri(itr);
        Assert.assertTrue((boolean)uri.contains("jsf.js"));
        Assert.assertTrue((boolean)uri.contains("javax.faces"));
        uri = this.nextUri(itr);
        Assert.assertTrue((boolean)uri.contains("org.richfaces"));
        Assert.assertTrue((boolean)uri.contains("jquery.js"));
        uri = this.nextUri(itr);
        Assert.assertTrue((boolean)uri.contains("org.richfaces"));
        Assert.assertTrue((boolean)uri.contains("richfaces.js"));
        uri = this.nextUri(itr);
        Assert.assertTrue((boolean)uri.contains("org.richfaces"));
        Assert.assertTrue((boolean)uri.contains("skinning_both.ecss"));
        Assert.assertFalse((boolean)itr.hasNext());
    }

    @Test
    public void testDynamicLibrary() throws Exception {
        this.environment.getApplication().addComponent("testComponent", DynamicLibraryComponent.class.getName());
        HtmlPage page = (HtmlPage)this.environment.getPage("/index.jsf");
        Iterator itr = page.getByXPath("//head/link | //head/script").iterator();
        String uri = this.nextUri(itr);
        Assert.assertTrue((boolean)uri.contains("skinning_classes.ecss"));
        uri = this.nextUri(itr);
        Assert.assertTrue((boolean)uri.contains("jquery.js"));
        Assert.assertFalse((boolean)itr.hasNext());
    }

    @ResourceDependency(library="org.richfaces", name="dynamic.reslib")
    public static class DynamicLibraryComponent
    extends UIComponentBase {
        public String getFamily() {
            return null;
        }
    }

    @ResourceDependency(library="org.richfaces", name="static.reslib")
    public static class StaticLibraryComponent
    extends UIComponentBase {
        public String getFamily() {
            return null;
        }
    }
}

