/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import org.junit.Assert;
import org.junit.Test;
import org.richfaces.resource.ResourceKey;

public class ResourceKeyEqualsHashcodeTest {
    private static final String NAME = "sample1";

    @Test
    public void testLibsNull() {
        this.assertKeysEqual(this.resourceKey(NAME, null), this.resourceKey(NAME, null));
    }

    @Test
    public void testLibsEmptyAndNull() {
        this.assertKeysEqual(this.resourceKey(NAME, ""), this.resourceKey(NAME, null));
    }

    @Test
    public void testLibsNonEmptyAndNull() {
        this.assertKeysNotEqual(this.resourceKey(NAME, "lib1"), this.resourceKey(NAME, null));
    }

    @Test
    public void testLibsEmpty() {
        this.assertKeysEqual(this.resourceKey(NAME, ""), this.resourceKey(NAME, ""));
    }

    @Test
    public void testLibsNotEqual() {
        this.assertKeysNotEqual(this.resourceKey(NAME, "lib1"), this.resourceKey(NAME, "lib2"));
    }

    @Test
    public void testNamesEquals() {
        this.assertKeysEqual(this.resourceKey(NAME, NAME), this.resourceKey(NAME, NAME));
    }

    @Test
    public void testNamesNull() {
        this.assertKeysEqual(this.resourceKey(null, NAME), this.resourceKey(null, NAME));
    }

    @Test
    public void testNamesNotEqual() {
        this.assertKeysNotEqual(this.resourceKey("name1", NAME), this.resourceKey("name2", NAME));
    }

    @Test
    public void testNamesOneNull() {
        this.assertKeysNotEqual(this.resourceKey(null, NAME), this.resourceKey("name2", NAME));
    }

    public void assertKeysEqual(ResourceKey key1, ResourceKey key2) {
        Assert.assertTrue((boolean)key1.equals((Object)key2));
        Assert.assertTrue((boolean)key2.equals((Object)key1));
        Assert.assertEquals((long)key1.hashCode(), (long)key2.hashCode());
    }

    public void assertKeysNotEqual(ResourceKey key1, ResourceKey key2) {
        Assert.assertFalse((boolean)key1.equals((Object)key2));
        Assert.assertFalse((boolean)key2.equals((Object)key1));
        Assert.assertTrue((key1.hashCode() != key2.hashCode() ? 1 : 0) != 0);
    }

    private ResourceKey resourceKey(String resourceName, String resourceLibrary) {
        return new ResourceKey(resourceName, resourceLibrary);
    }
}

