/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.faces.context.FacesContext;
import org.easymock.IAnswer;
import org.easymock.classextension.EasyMock;
import org.jboss.test.faces.AbstractFacesTest;
import org.jboss.test.faces.mock.FacesMock;
import org.richfaces.resource.AbstractCacheableResource;
import org.richfaces.resource.MockAbstractResource;

public class AbstractCacheableResourceTest
extends AbstractFacesTest {
    private static final int MILLISECONDS_IN_HOUR = 3600000;
    private static final String RFC1123_DATE_PATTERN = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final SimpleDateFormat RFC1123_DATE_FORMATTER;

    public void setUp() throws Exception {
        super.setUp();
        this.setupFacesRequest();
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testInitialRequest() throws Exception {
        MockAbstractResource defaultResource = new MockAbstractResource();
        AbstractCacheableResourceTest.assertNull((Object)defaultResource.isMatchesEntityTag(this.facesContext));
        AbstractCacheableResourceTest.assertNull((Object)defaultResource.isMatchesLastModified(this.facesContext));
        MockAbstractResource entityTaggedResource = new MockAbstractResource();
        entityTaggedResource.setEntityTag("3456");
        AbstractCacheableResourceTest.assertNull((Object)entityTaggedResource.isMatchesEntityTag(this.facesContext));
        AbstractCacheableResourceTest.assertNull((Object)entityTaggedResource.isMatchesLastModified(this.facesContext));
        MockAbstractResource timeKnownResource = new MockAbstractResource();
        timeKnownResource.setLastModified(new Date(System.currentTimeMillis() - 3600000L));
        AbstractCacheableResourceTest.assertNull((Object)timeKnownResource.isMatchesEntityTag(this.facesContext));
        AbstractCacheableResourceTest.assertNull((Object)timeKnownResource.isMatchesLastModified(this.facesContext));
    }

    public void testEntityTag() throws Exception {
        this.connection.addRequestHeaders(Collections.singletonMap("If-None-Match", "\"3456\""));
        MockAbstractResource defaultResource = new MockAbstractResource();
        AbstractCacheableResourceTest.assertFalse((boolean)defaultResource.isMatchesEntityTag(this.facesContext));
        MockAbstractResource entityTaggedResource = new MockAbstractResource();
        entityTaggedResource.setEntityTag("\"3456\"");
        AbstractCacheableResourceTest.assertTrue((boolean)entityTaggedResource.isMatchesEntityTag(this.facesContext));
        MockAbstractResource unmatchedTaggedResource = new MockAbstractResource();
        unmatchedTaggedResource.setEntityTag("\"123\"");
        AbstractCacheableResourceTest.assertFalse((boolean)unmatchedTaggedResource.isMatchesEntityTag(this.facesContext));
    }

    public void testWeakEntityTag() throws Exception {
        this.connection.addRequestHeaders(Collections.singletonMap("If-None-Match", "W/\"3456\""));
        MockAbstractResource defaultResource = new MockAbstractResource();
        AbstractCacheableResourceTest.assertEquals((Object)Boolean.FALSE, (Object)defaultResource.isMatchesEntityTag(this.facesContext));
        MockAbstractResource entityTaggedResource = new MockAbstractResource();
        entityTaggedResource.setEntityTag("\"3456\"");
        AbstractCacheableResourceTest.assertEquals((Object)Boolean.TRUE, (Object)entityTaggedResource.isMatchesEntityTag(this.facesContext));
        MockAbstractResource unmatchedTaggedResource = new MockAbstractResource();
        unmatchedTaggedResource.setEntityTag("\"123\"");
        AbstractCacheableResourceTest.assertEquals((Object)Boolean.FALSE, (Object)unmatchedTaggedResource.isMatchesEntityTag(this.facesContext));
    }

    public void testMultiEntityTags() throws Exception {
        this.connection.addRequestHeaders(Collections.singletonMap("If-None-Match", "W/\"3456\", \"012\""));
        MockAbstractResource defaultResource = new MockAbstractResource();
        AbstractCacheableResourceTest.assertEquals((Object)Boolean.FALSE, (Object)defaultResource.isMatchesEntityTag(this.facesContext));
        MockAbstractResource entityTaggedResource = new MockAbstractResource();
        entityTaggedResource.setEntityTag("\"3456\"");
        AbstractCacheableResourceTest.assertEquals((Object)Boolean.TRUE, (Object)entityTaggedResource.isMatchesEntityTag(this.facesContext));
        MockAbstractResource anotherTaggedResource = new MockAbstractResource();
        anotherTaggedResource.setEntityTag("W/\"012\"");
        AbstractCacheableResourceTest.assertEquals((Object)Boolean.TRUE, (Object)anotherTaggedResource.isMatchesEntityTag(this.facesContext));
        MockAbstractResource unmatchedTaggedResource = new MockAbstractResource();
        unmatchedTaggedResource.setEntityTag("\"123\"");
        AbstractCacheableResourceTest.assertEquals((Object)Boolean.FALSE, (Object)unmatchedTaggedResource.isMatchesEntityTag(this.facesContext));
    }

    public void testIfModified() throws Exception {
        Date baseDate = new Date();
        Date beforeBaseDate = new Date(baseDate.getTime() - 3600000L);
        Date afterBaseDate = new Date(baseDate.getTime() + 3600000L);
        this.connection.addRequestHeaders(Collections.singletonMap("If-Modified-Since", RFC1123_DATE_FORMATTER.format(baseDate)));
        MockAbstractResource defaultResource = new MockAbstractResource();
        AbstractCacheableResourceTest.assertEquals((Object)Boolean.FALSE, (Object)defaultResource.isMatchesLastModified(this.facesContext));
        MockAbstractResource actualResource = new MockAbstractResource();
        actualResource.setLastModified(beforeBaseDate);
        AbstractCacheableResourceTest.assertEquals((Object)Boolean.TRUE, (Object)actualResource.isMatchesLastModified(this.facesContext));
        MockAbstractResource expiredResource = new MockAbstractResource();
        expiredResource.setLastModified(afterBaseDate);
        AbstractCacheableResourceTest.assertEquals((Object)Boolean.FALSE, (Object)expiredResource.isMatchesLastModified(this.facesContext));
    }

    public void testUserAgentNeedsUpdate() throws Exception {
        BooleanAnswer tagMatches = new BooleanAnswer();
        BooleanAnswer lastModifiedMatches = new BooleanAnswer();
        BooleanAnswer cacheable = new BooleanAnswer();
        AbstractCacheableResource resource = (AbstractCacheableResource)FacesMock.createControl().createMock(AbstractTestResource.class, AbstractTestResource.class.getDeclaredMethods());
        EasyMock.expect((Object)resource.isCacheable(this.facesContext)).andStubAnswer((IAnswer)cacheable);
        String matchHeaderValue = RFC1123_DATE_FORMATTER.format(new Date());
        this.connection.addRequestHeaders(Collections.singletonMap("If-None-Match", matchHeaderValue));
        EasyMock.expect((Object)resource.isMatchesEntityTag(this.facesContext, matchHeaderValue)).andStubAnswer((IAnswer)tagMatches);
        String modifiedCondition = "\"1234\"";
        this.connection.addRequestHeaders(Collections.singletonMap("If-Modified-Since", modifiedCondition));
        EasyMock.expect((Object)resource.isMatchesLastModified(this.facesContext, modifiedCondition)).andStubAnswer((IAnswer)lastModifiedMatches);
        EasyMock.replay((Object[])new Object[]{resource});
        cacheable.setValue(false);
        AbstractCacheableResourceTest.assertTrue((boolean)resource.userAgentNeedsUpdate(this.facesContext));
        cacheable.setValue(true);
        tagMatches.setValue(Boolean.TRUE);
        lastModifiedMatches.setValue(Boolean.TRUE);
        AbstractCacheableResourceTest.assertFalse((boolean)resource.userAgentNeedsUpdate(this.facesContext));
        tagMatches.setValue(Boolean.FALSE);
        lastModifiedMatches.setValue(Boolean.FALSE);
        AbstractCacheableResourceTest.assertTrue((boolean)resource.userAgentNeedsUpdate(this.facesContext));
        tagMatches.setValue(Boolean.FALSE);
        lastModifiedMatches.setValue(Boolean.TRUE);
        AbstractCacheableResourceTest.assertTrue((boolean)resource.userAgentNeedsUpdate(this.facesContext));
        tagMatches.setValue(Boolean.TRUE);
        lastModifiedMatches.setValue(Boolean.FALSE);
        AbstractCacheableResourceTest.assertTrue((boolean)resource.userAgentNeedsUpdate(this.facesContext));
        this.connection.addRequestHeaders(Collections.singletonMap("If-None-Match", null));
        lastModifiedMatches.setValue(Boolean.FALSE);
        AbstractCacheableResourceTest.assertTrue((boolean)resource.userAgentNeedsUpdate(this.facesContext));
        lastModifiedMatches.setValue(Boolean.TRUE);
        AbstractCacheableResourceTest.assertFalse((boolean)resource.userAgentNeedsUpdate(this.facesContext));
        this.connection.addRequestHeaders(Collections.singletonMap("If-None-Match", matchHeaderValue));
        this.connection.addRequestHeaders(Collections.singletonMap("If-Modified-Since", null));
        tagMatches.setValue(Boolean.FALSE);
        AbstractCacheableResourceTest.assertTrue((boolean)resource.userAgentNeedsUpdate(this.facesContext));
        tagMatches.setValue(Boolean.TRUE);
        AbstractCacheableResourceTest.assertFalse((boolean)resource.userAgentNeedsUpdate(this.facesContext));
        this.connection.addRequestHeaders(Collections.singletonMap("If-Modified-Since", null));
        this.connection.addRequestHeaders(Collections.singletonMap("If-None-Match", null));
        AbstractCacheableResourceTest.assertTrue((boolean)resource.userAgentNeedsUpdate(this.facesContext));
        cacheable.setValue(false);
        AbstractCacheableResourceTest.assertTrue((boolean)resource.userAgentNeedsUpdate(this.facesContext));
    }

    static {
        SimpleDateFormat format = new SimpleDateFormat(RFC1123_DATE_PATTERN, Locale.US);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        RFC1123_DATE_FORMATTER = format;
    }

    private static class BooleanAnswer
    implements IAnswer<Boolean> {
        private Boolean value;

        private BooleanAnswer() {
        }

        public Boolean answer() throws Throwable {
            return this.value;
        }

        public void setValue(Boolean value) {
            this.value = value;
        }
    }

    public static abstract class AbstractTestResource
    extends AbstractCacheableResource {
        public String toString() {
            return "mock";
        }

        public boolean isCacheable(FacesContext context) {
            return false;
        }

        protected boolean isMatchesEntityTag(FacesContext context, String matchHeaderValue) {
            return super.isMatchesEntityTag(context, matchHeaderValue);
        }

        protected boolean isMatchesLastModified(FacesContext context, String modifiedCondition) {
            return super.isMatchesLastModified(context, modifiedCondition);
        }
    }
}

