/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import javax.faces.context.FacesContext;
import org.easymock.EasyMock;
import org.jboss.test.faces.AbstractFacesTest;
import org.richfaces.application.Module;
import org.richfaces.application.ServiceTracker;
import org.richfaces.application.ServicesFactory;
import org.richfaces.application.ServicesFactoryImpl;
import org.richfaces.application.Uptime;
import org.richfaces.resource.AbstractCacheableResource;
import org.richfaces.resource.ResourceCodec;
import org.richfaces.resource.ResourceUtils;
import org.richfaces.resource.StateHolderResource;
import org.richfaces.resource.VersionedResource;

public class AbstractBaseResourceTest
extends AbstractFacesTest {
    public void setUp() throws Exception {
        super.setUp();
        this.setupFacesRequest();
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetHeaders() throws Exception {
        MockResourceImpl mockResource = new MockResourceImpl();
        mockResource.setCacheable(true);
        mockResource.setEntityTag("\"etag0\"");
        mockResource.setContentLength(80);
        mockResource.setContentType("image/png");
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.clear();
        calendar.set(2009, 6, 13, 12, 45, 9);
        mockResource.setLastModified(calendar.getTime());
        calendar.add(5, 1);
        mockResource.setCurrentTime(calendar.getTimeInMillis());
        calendar.add(5, 7);
        mockResource.setExpired(calendar.getTime());
        Map headers = mockResource.getResponseHeaders();
        AbstractBaseResourceTest.assertEquals((String)"Tue, 21 Jul 2009 12:45:09 GMT", (String)((String)headers.get("Expires")));
        AbstractBaseResourceTest.assertEquals((String)"Mon, 13 Jul 2009 12:45:09 GMT", (String)((String)headers.get("Last-Modified")));
        AbstractBaseResourceTest.assertEquals((String)"Tue, 14 Jul 2009 12:45:09 GMT", (String)((String)headers.get("Date")));
        AbstractBaseResourceTest.assertEquals((String)"\"etag0\"", (String)((String)headers.get("ETag")));
        AbstractBaseResourceTest.assertEquals((String)"max-age=604800", (String)((String)headers.get("Cache-Control")));
        AbstractBaseResourceTest.assertEquals((String)"80", (String)((String)headers.get("Content-Length")));
        AbstractBaseResourceTest.assertEquals((String)"image/png", (String)((String)headers.get("Content-Type")));
        AbstractBaseResourceTest.assertEquals((int)7, (int)headers.size());
        mockResource.setTimeToLive(1209600);
        headers = mockResource.getResponseHeaders();
        AbstractBaseResourceTest.assertEquals((String)"Tue, 28 Jul 2009 12:45:09 GMT", (String)((String)headers.get("Expires")));
        AbstractBaseResourceTest.assertEquals((String)"Mon, 13 Jul 2009 12:45:09 GMT", (String)((String)headers.get("Last-Modified")));
        AbstractBaseResourceTest.assertEquals((String)"Tue, 14 Jul 2009 12:45:09 GMT", (String)((String)headers.get("Date")));
        AbstractBaseResourceTest.assertEquals((String)"max-age=1209600", (String)((String)headers.get("Cache-Control")));
    }

    public void testGetHeadersNonCacheable() throws Exception {
        MockResourceImpl mockResource = new MockResourceImpl();
        mockResource.setCacheable(false);
        mockResource.setContentLength(120);
        mockResource.setContentType("image/jpg");
        mockResource.setEntityTag("\"etag1\"");
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.clear();
        calendar.set(2009, 6, 13, 12, 45, 9);
        mockResource.setLastModified(calendar.getTime());
        calendar.add(5, 1);
        mockResource.setCurrentTime(calendar.getTimeInMillis());
        calendar.add(5, 7);
        mockResource.setExpired(calendar.getTime());
        Map headers = mockResource.getResponseHeaders();
        AbstractBaseResourceTest.assertEquals((String)"0", (String)((String)headers.get("Expires")));
        AbstractBaseResourceTest.assertEquals((String)"max-age=0, no-store, no-cache", (String)((String)headers.get("Cache-Control")));
        AbstractBaseResourceTest.assertEquals((String)"no-cache", (String)((String)headers.get("Pragma")));
        AbstractBaseResourceTest.assertEquals((String)"120", (String)((String)headers.get("Content-Length")));
        AbstractBaseResourceTest.assertEquals((String)"image/jpg", (String)((String)headers.get("Content-Type")));
        AbstractBaseResourceTest.assertEquals((String)"Mon, 13 Jul 2009 12:45:09 GMT", (String)((String)headers.get("Last-Modified")));
        AbstractBaseResourceTest.assertEquals((String)"Tue, 14 Jul 2009 12:45:09 GMT", (String)((String)headers.get("Date")));
        AbstractBaseResourceTest.assertEquals((int)7, (int)headers.size());
    }

    public void testGetRequestPath() throws Exception {
        String resourceState = "data";
        final ResourceCodec resourceCodec = (ResourceCodec)EasyMock.createMock(ResourceCodec.class);
        EasyMock.expect((Object)resourceCodec.encodeResourceRequestPath((FacesContext)EasyMock.same((Object)this.facesContext), (String)EasyMock.eq((Object)"custom.library"), (String)EasyMock.eq((Object)"org.richfaces.resource.MockStateAwareResource"), (Object)EasyMock.aryEq((byte[])resourceState.getBytes()), (String)EasyMock.eq((Object)"4_0_alpha"))).andReturn((Object)"/rfRes/Resource0/4_0_alpha/data?l=custom.library");
        EasyMock.expect((Object)resourceCodec.encodeJSFMapping((FacesContext)EasyMock.same((Object)this.facesContext), (String)EasyMock.eq((Object)"/rfRes/Resource0/4_0_alpha/data?l=custom.library"))).andReturn((Object)"/rfRes/Resource0/4_0_alpha/data.jsf?l=custom.library");
        EasyMock.expect((Object)resourceCodec.encodeResourceRequestPath((FacesContext)EasyMock.same((Object)this.facesContext), (String)EasyMock.eq((Object)"custom.library"), (String)EasyMock.eq((Object)"org.richfaces.resource.MockStateAwareResource"), EasyMock.eq(null), (String)EasyMock.eq((Object)"4_0_alpha"))).andReturn((Object)"/rfRes/Resource1/4_0_alpha?l=custom.library");
        EasyMock.expect((Object)resourceCodec.encodeJSFMapping((FacesContext)EasyMock.same((Object)this.facesContext), (String)EasyMock.eq((Object)"/rfRes/Resource1/4_0_alpha?l=custom.library"))).andReturn((Object)"/rfRes/Resource1/4_0_alpha.jsf?l=custom.library");
        EasyMock.expect((Object)resourceCodec.encodeResourceRequestPath((FacesContext)EasyMock.same((Object)this.facesContext), (String)EasyMock.isNull(), (String)EasyMock.eq((Object)"org.richfaces.resource.MockResource"), EasyMock.eq(null), (String)EasyMock.eq((Object)"4_0_alpha"))).andReturn((Object)"/rfRes/Resource2/4_0_alpha");
        EasyMock.expect((Object)resourceCodec.encodeJSFMapping((FacesContext)EasyMock.same((Object)this.facesContext), (String)EasyMock.eq((Object)"/rfRes/Resource2/4_0_alpha"))).andReturn((Object)"/rfRes/Resource2/4_0_alpha.jsf");
        EasyMock.replay((Object[])new Object[]{resourceCodec});
        ServicesFactoryImpl injector = new ServicesFactoryImpl();
        injector.init(Collections.singletonList(new Module(){

            public void configure(ServicesFactory injector) {
                injector.setInstance(ResourceCodec.class, (Object)resourceCodec);
                injector.setInstance(Uptime.class, (Object)new Uptime());
            }
        }));
        ServiceTracker.setFactory((ServicesFactory)injector);
        MockStateAwareResourceImpl stateAwareResourceImpl = new MockStateAwareResourceImpl();
        stateAwareResourceImpl.setLibraryName("custom.library");
        stateAwareResourceImpl.setVersion("4_0_alpha");
        stateAwareResourceImpl.setState(resourceState);
        AbstractBaseResourceTest.assertEquals((String)"org.richfaces.resource.MockStateAwareResource", (String)stateAwareResourceImpl.getResourceName());
        AbstractBaseResourceTest.assertEquals((String)"/rfRes/Resource0/4_0_alpha/data.jsf?l=custom.library", (String)stateAwareResourceImpl.getRequestPath());
        stateAwareResourceImpl.setTransient(true);
        AbstractBaseResourceTest.assertEquals((String)"/rfRes/Resource1/4_0_alpha.jsf?l=custom.library", (String)stateAwareResourceImpl.getRequestPath());
        MockResourceImpl resourceImpl = new MockResourceImpl();
        resourceImpl.setVersion("4_0_alpha");
        AbstractBaseResourceTest.assertEquals((String)"org.richfaces.resource.MockResource", (String)resourceImpl.getResourceName());
        AbstractBaseResourceTest.assertEquals((String)"/rfRes/Resource2/4_0_alpha.jsf", (String)resourceImpl.getRequestPath());
        EasyMock.verify((Object[])new Object[]{resourceCodec});
    }

    public void testGetURL() throws Exception {
        ByteArrayInputStream stream = new ByteArrayInputStream(new byte[0]);
        MockResourceImpl mockResource = new MockResourceImpl();
        mockResource.setContentLength(130);
        mockResource.setContentType("image/gif");
        mockResource.setInputStream(stream);
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.clear();
        calendar.set(2009, 5, 12, 21, 38, 59);
        Date lastModified = calendar.getTime();
        mockResource.setLastModified(lastModified);
        calendar.add(2, 1);
        Date expired = calendar.getTime();
        mockResource.setExpired(expired);
        URL url = mockResource.getURL();
        AbstractBaseResourceTest.assertNotNull((Object)url);
        AbstractBaseResourceTest.assertEquals((String)"jsfresource:org.richfaces.resource.MockResource", (String)url.toExternalForm());
        URLConnection urlConnection = url.openConnection();
        AbstractBaseResourceTest.assertNotNull((Object)urlConnection);
        urlConnection.connect();
        AbstractBaseResourceTest.assertEquals((int)130, (int)urlConnection.getContentLength());
        AbstractBaseResourceTest.assertEquals((String)"image/gif", (String)urlConnection.getContentType());
        AbstractBaseResourceTest.assertEquals((long)lastModified.getTime(), (long)urlConnection.getLastModified());
        AbstractBaseResourceTest.assertSame((Object)stream, (Object)urlConnection.getInputStream());
        AbstractBaseResourceTest.assertSame((Object)url, (Object)urlConnection.getURL());
        MockResourceImpl mockResource2 = new MockResourceImpl();
        URLConnection urlConnection2 = mockResource2.getURL().openConnection();
        urlConnection2.connect();
        AbstractBaseResourceTest.assertEquals((int)-1, (int)urlConnection2.getContentLength());
        AbstractBaseResourceTest.assertNull((Object)urlConnection2.getContentType());
        AbstractBaseResourceTest.assertEquals((long)0L, (long)urlConnection2.getLastModified());
    }

    public void testDefaults() throws Exception {
        ResourceImpl defaultResource = new ResourceImpl();
        AbstractBaseResourceTest.assertTrue((boolean)defaultResource.isCacheable(this.facesContext));
        AbstractBaseResourceTest.assertEquals((String)"org.richfaces.resource.ResourceImpl", (String)defaultResource.getResourceName());
        AbstractBaseResourceTest.assertEquals((int)-1, (int)defaultResource.getContentLength(this.facesContext));
        AbstractBaseResourceTest.assertNull((Object)defaultResource.getEntityTag(this.facesContext));
        AbstractBaseResourceTest.assertNull((Object)defaultResource.getExpires(this.facesContext));
        Date lastModified = defaultResource.getLastModified(this.facesContext);
        AbstractBaseResourceTest.assertNotNull((Object)lastModified);
        AbstractBaseResourceTest.assertTrue((System.currentTimeMillis() >= lastModified.getTime() ? 1 : 0) != 0);
        ResourceImpl defaultETagResource = new ResourceImpl(){

            protected Date getLastModified(FacesContext context) {
                return new Date(12471234567890L);
            }

            protected int getContentLength(FacesContext context) {
                return 1297;
            }
        };
        AbstractBaseResourceTest.assertEquals((String)"W/\"1297-12471234567890\"", (String)defaultETagResource.getEntityTag(this.facesContext));
    }

    public void testUserAgentNeedsUpdate() throws Exception {
        long currentTime = System.currentTimeMillis();
        MockResourceImpl actualResource = new MockResourceImpl();
        actualResource.setLastModified(new Date(currentTime - 30000L));
        MockResourceImpl expiredResource = new MockResourceImpl();
        expiredResource.setLastModified(new Date(currentTime - 10000L));
        this.connection.addRequestHeaders(Collections.singletonMap("If-Modified-Since", ResourceUtils.formatHttpDate((Object)new Date(currentTime - 20000L))));
        AbstractBaseResourceTest.assertTrue((boolean)expiredResource.userAgentNeedsUpdate(this.facesContext));
        AbstractBaseResourceTest.assertFalse((boolean)actualResource.userAgentNeedsUpdate(this.facesContext));
    }

    private class ResourceImpl
    extends AbstractCacheableResource {
        public ResourceImpl() {
            this.setResourceName("org.richfaces.resource.ResourceImpl");
        }

        public InputStream getInputStream() throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private class MockStateAwareResourceImpl
    extends MockResourceImpl
    implements StateHolderResource {
        private boolean _transient;
        private String resourceState;

        public MockStateAwareResourceImpl() {
            this.setResourceName("org.richfaces.resource.MockStateAwareResource");
        }

        public void setState(String resourceState) {
            this.resourceState = resourceState;
        }

        public void setTransient(boolean transient1) {
            this._transient = transient1;
        }

        public boolean isTransient() {
            return this._transient;
        }

        public void readState(FacesContext context, DataInput dataInput) throws IOException {
            this.resourceState = dataInput.readLine();
        }

        public void writeState(FacesContext context, DataOutput objectOutput) throws IOException {
            objectOutput.writeBytes(this.resourceState);
        }
    }

    private class MockResourceImpl
    extends AbstractCacheableResource
    implements VersionedResource {
        private int contentLength = -1;
        private long currentTime;
        private String entityTag;
        private Date expired;
        private InputStream inputStream;
        private Date lastModified;
        private int ttl;
        private String version;

        public MockResourceImpl() {
            this.setResourceName("org.richfaces.resource.MockResource");
        }

        protected int getContentLength(FacesContext context) {
            return this.contentLength;
        }

        public InputStream getInputStream() throws IOException {
            return this.inputStream;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public void setContentLength(int contentLength) {
            this.contentLength = contentLength;
        }

        public void setInputStream(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        protected Date getLastModified(FacesContext context) {
            return this.lastModified;
        }

        public void setLastModified(Date lastModified) {
            this.lastModified = lastModified;
        }

        public Date getExpires(FacesContext context) {
            return this.expired;
        }

        public void setExpired(Date expired) {
            this.expired = expired;
        }

        public String getEntityTag(FacesContext context) {
            return this.entityTag;
        }

        public void setEntityTag(String entityTag) {
            this.entityTag = entityTag;
        }

        boolean isResourceRequest() {
            return true;
        }

        protected long getCurrentTime() {
            return this.currentTime;
        }

        void setCurrentTime(long currentTime) {
            this.currentTime = currentTime;
        }

        public int getTimeToLive(FacesContext context) {
            return this.ttl;
        }

        public void setTimeToLive(int ttl) {
            this.ttl = ttl;
        }
    }
}

