/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.log;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.richfaces.log.JavaLogger;
import org.richfaces.log.Logger;
import org.richfaces.log.LoggerTestMessages;

public class JavaLoggerTest {
    private static final String ANOTHER_DUMMY_MESSAGE = "another message";
    private static final String DUMMY_MESSAGE = "message";
    private static final String TEST_MESSAGE_PATTERN = "RF-000000 Test message with arguments: {0} and {1}";
    private static final String CHAR_SEQUENCE_THROWABLE_PATTERN = "(CharSequence, Throwable)({0})";
    private static final String CHAR_SEQUENCE_PATTERN = "(CharSequence)({0})";
    private java.util.logging.Logger wrappedLogger;
    private JavaLogger logger;
    private List<LogRecord> publishedRecords;

    @Before
    public void setUp() throws Exception {
        LogManager.getLogManager().reset();
        this.publishedRecords = new ArrayList<LogRecord>();
        this.wrappedLogger = java.util.logging.Logger.getLogger("org.richfaces.JavaLoggerTest");
        this.wrappedLogger.addHandler(new TrackingHandler());
        this.logger = new JavaLogger(this.wrappedLogger.getName());
    }

    @After
    public void tearDown() throws Exception {
        this.publishedRecords = null;
        this.wrappedLogger = null;
        this.logger = null;
    }

    private void verifyLogRecord(LogRecord logRecord, Logger.Level level, String message, Class<? extends Throwable> thrownClass, String thrownMessage) {
        Assert.assertEquals(JavaLogger.LEVELS_MAP.get(level), (Object)logRecord.getLevel());
        Assert.assertEquals((Object)message, (Object)logRecord.getMessage());
        if (thrownClass != null && thrownMessage != null) {
            Assert.assertTrue((boolean)thrownClass.isInstance(logRecord.getThrown()));
            Assert.assertEquals((Object)thrownMessage, (Object)logRecord.getThrown().getMessage());
        } else {
            Assert.assertNull((Object)logRecord.getThrown());
        }
    }

    private void verifyEnabledMethods(Logger.Level loggerLevel) throws Exception {
        String[] levels = new String[]{"Debug", "Info", "Warn", "Error"};
        for (Logger.Level level : Logger.Level.values()) {
            boolean enabledValue = (Boolean)Logger.class.getMethod(MessageFormat.format("is{0}Enabled", levels[level.ordinal()]), new Class[0]).invoke((Object)this.logger, new Object[0]);
            if (level.compareTo((Enum)loggerLevel) < 0) {
                Assert.assertFalse((String)loggerLevel.toString(), (boolean)enabledValue);
                continue;
            }
            Assert.assertTrue((String)loggerLevel.toString(), (boolean)enabledValue);
        }
    }

    private void verifyLoggingLevels(Logger.Level loggerLevel) {
        for (Logger.Level messageLevel : Logger.Level.values()) {
            this.logger.log(messageLevel, (CharSequence)"test");
            if (messageLevel.compareTo((Enum)loggerLevel) < 0) {
                Assert.assertTrue((boolean)this.publishedRecords.isEmpty());
                continue;
            }
            Assert.assertTrue((this.publishedRecords.size() == 1 ? 1 : 0) != 0);
            this.publishedRecords.clear();
        }
    }

    @Test
    public void testLogging() throws Exception {
        String[] levels;
        this.wrappedLogger.setLevel(Level.ALL);
        for (String levelName : levels = new String[]{"debug", "info", "warn", "error"}) {
            Logger.class.getMethod(levelName, CharSequence.class).invoke((Object)this.logger, MessageFormat.format(CHAR_SEQUENCE_PATTERN, levelName));
            Logger.class.getMethod(levelName, CharSequence.class, Throwable.class).invoke((Object)this.logger, MessageFormat.format(CHAR_SEQUENCE_THROWABLE_PATTERN, levelName), new NullPointerException(levelName));
            Logger.class.getMethod(levelName, Enum.class, Object[].class).invoke((Object)this.logger, new Object[]{LoggerTestMessages.TEST_MESSAGE, new Object[]{levelName, DUMMY_MESSAGE}});
            Logger.class.getMethod(levelName, Throwable.class).invoke((Object)this.logger, new IllegalArgumentException(levelName));
            Logger.class.getMethod(levelName, Throwable.class, Enum.class, Object[].class).invoke((Object)this.logger, new Object[]{new UnsupportedOperationException(levelName), LoggerTestMessages.TEST_MESSAGE, new Object[]{levelName, ANOTHER_DUMMY_MESSAGE}});
        }
        Iterator<LogRecord> iterator = this.publishedRecords.iterator();
        for (Logger.Level level : Logger.Level.values()) {
            String levelName = levels[level.ordinal()];
            this.verifyLogRecord(iterator.next(), level, MessageFormat.format(CHAR_SEQUENCE_PATTERN, levelName), null, null);
            this.verifyLogRecord(iterator.next(), level, MessageFormat.format(CHAR_SEQUENCE_THROWABLE_PATTERN, levelName), NullPointerException.class, levelName);
            this.verifyLogRecord(iterator.next(), level, MessageFormat.format(TEST_MESSAGE_PATTERN, levelName, DUMMY_MESSAGE), null, null);
            this.verifyLogRecord(iterator.next(), level, null, IllegalArgumentException.class, levelName);
            this.verifyLogRecord(iterator.next(), level, MessageFormat.format(TEST_MESSAGE_PATTERN, levelName, ANOTHER_DUMMY_MESSAGE), UnsupportedOperationException.class, levelName);
        }
    }

    @Test
    public void testLevels() throws Exception {
        for (Logger.Level loggerLevel : Logger.Level.values()) {
            this.wrappedLogger.setLevel((Level)JavaLogger.LEVELS_MAP.get(loggerLevel));
            this.verifyEnabledMethods(loggerLevel);
            this.verifyLoggingLevels(loggerLevel);
        }
    }

    private final class TrackingHandler
    extends Handler {
        private TrackingHandler() {
        }

        @Override
        public void publish(LogRecord record) {
            JavaLoggerTest.this.publishedRecords.add(record);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }
}

