/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.l10n;

import java.util.Locale;
import java.util.MissingResourceException;
import org.easymock.EasyMock;
import org.jboss.test.faces.mock.MockFacesEnvironment;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.richfaces.l10n.BundleLoader;
import org.richfaces.l10n.BundleLoaderCoreMessages;

public class BundleLoaderTest {
    private MockFacesEnvironment facesEnvironment;
    private BundleLoader bundleLoader;

    @Before
    public void setUp() throws Exception {
        Locale.setDefault(Locale.ENGLISH);
        this.bundleLoader = new BundleLoader();
        this.facesEnvironment = MockFacesEnvironment.createEnvironment().withApplication();
    }

    @After
    public void tearDown() throws Exception {
        this.bundleLoader = null;
        this.facesEnvironment.verify();
        this.facesEnvironment.release();
        this.facesEnvironment = null;
    }

    @Test
    public void testGetMessageBundle() throws Exception {
        this.facesEnvironment.replay();
        Assert.assertEquals((Object)"Hello", (Object)this.bundleLoader.getBundle((Enum)BundleLoaderCoreMessages.message, Locale.US).getString("message"));
        Assert.assertEquals((Object)"Zdravstvujte", (Object)this.bundleLoader.getBundle((Enum)BundleLoaderCoreMessages.message, new Locale("ru", "RU")).getString("message"));
        try {
            this.bundleLoader.getBundle((Enum)BundleLoaderCoreMessages.message, new Locale("by", "BY"));
            Assert.fail();
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    @Test
    public void testGetApplicationBundle() throws Exception {
        EasyMock.expect((Object)this.facesEnvironment.getApplication().getMessageBundle()).andStubReturn((Object)"org.richfaces.l10n.AppMessages");
        this.facesEnvironment.replay();
        Assert.assertEquals((Object)"Welcome to app", (Object)this.bundleLoader.getApplicationBundle(this.facesEnvironment.getFacesContext(), (Enum)BundleLoaderCoreMessages.message, Locale.US).getString("message"));
        Assert.assertEquals((Object)"Dobro pozhalovat'", (Object)this.bundleLoader.getApplicationBundle(this.facesEnvironment.getFacesContext(), (Enum)BundleLoaderCoreMessages.message, new Locale("by", "BY")).getString("message"));
        try {
            this.bundleLoader.getApplicationBundle(this.facesEnvironment.getFacesContext(), (Enum)BundleLoaderCoreMessages.message, new Locale("ru", "RU"));
            Assert.fail();
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }
}

