/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.javascript;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlListItem;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.net.URL;
import java.util.Iterator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class QUnitTest {
    private WebClient webClient_;

    @Before
    public void setUp() {
        this.webClient_ = new WebClient(BrowserVersion.INTERNET_EXPLORER_11);
    }

    @After
    public void tearDown() {
        this.webClient_.closeAllWindows();
        this.webClient_ = null;
    }

    protected void runTest(URL url, String query) throws Exception {
        String urlStr = url.toExternalForm() + query;
        URL newURL = new URL(urlStr);
        this.runTest(newURL);
    }

    protected void runTest(URL url) throws Exception {
        HtmlPage page = this.loadPage(url);
        DomElement tests = page.getElementById("qunit-tests");
        Iterator iter = tests.getChildElements().iterator();
        if (!iter.hasNext()) {
            Assert.fail((String)"No result found");
        }
        StringBuilder sb = new StringBuilder();
        int i = 1;
        while (iter.hasNext()) {
            HtmlListItem testNode = (HtmlListItem)iter.next();
            if (testNode.getAttribute("class").contains("fail")) {
                sb.append(i).append(".  ").append(((HtmlElement)testNode.getFirstByXPath("./strong")).getFirstChild().getTextContent()).append("\n");
                int j = 1;
                for (DomElement li : ((DomElement)testNode.getFirstByXPath("./ol")).getChildElements()) {
                    if (li.getAttribute("class").contains("fail")) {
                        sb.append("     ").append(j).append(". ").append(li.getTextContent()).append("\n");
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (sb.length() > 0) {
            Assert.fail((String)("Failures:\n" + sb + "User Agent: " + page.getElementById("qunit-userAgent").getTextContent()));
        }
    }

    protected HtmlPage loadPage(URL url) throws Exception {
        HtmlPage page = (HtmlPage)this.webClient_.getPage(url);
        this.webClient_.waitForBackgroundJavaScriptStartingBefore(240000L);
        return page;
    }

    @Test
    public void test() throws Exception {
        this.runTest(this.getClass().getClassLoader().getResource("javascript/4_0_0.html"));
    }

    @Test
    public void testEvent() throws Exception {
        this.runTest(this.getClass().getClassLoader().getResource("javascript/richfaces-client-api.html"), "?module=richfaces-event");
    }

    @Test
    public void testPosition() throws Exception {
        this.runTest(this.getClass().getClassLoader().getResource("javascript/richfaces-client-api.html"), "?module=jquery-position");
    }

    @Test
    public void testQueueRequest() throws Exception {
        this.runTest(this.getClass().getClassLoader().getResource("javascript/richfaces-client-api.html"), "?module=richfaces-queue-request");
    }

    @Test
    public void testQueueGetSize() throws Exception {
        this.runTest(this.getClass().getClassLoader().getResource("javascript/richfaces-client-api.html"), "?module=richfaces-queue-getSize");
    }

    @Test
    public void testQueueEmpty() throws Exception {
        this.runTest(this.getClass().getClassLoader().getResource("javascript/richfaces-client-api.html"), "?module=richfaces-queue-isEmpty");
    }

    @Test
    public void testQueueClear() throws Exception {
        this.runTest(this.getClass().getClassLoader().getResource("javascript/richfaces-client-api.html"), "?module=richfaces-queue-clear");
    }

    @Test
    public void testQueueSubmitFirst() throws Exception {
        this.runTest(this.getClass().getClassLoader().getResource("javascript/richfaces-client-api.html"), "?module=richfaces-queue-submitFirst");
    }

    @Test
    public void testBaseComponent() throws Exception {
        this.runTest(this.getClass().getClassLoader().getResource("javascript/richfaces-client-api.html"), "?module=richfaces-base-component");
    }

    @Test
    public void testRemoveStaleEntries() throws Exception {
        this.runTest(this.getClass().getClassLoader().getResource("javascript/richfaces-client-api.html"), "?module=richfaces-queue-remove-stale-entries");
    }
}

