/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.io.io;

import junit.framework.TestCase;
import org.ajax4jsf.io.CharBuffer;
import org.ajax4jsf.io.FastBufferReader;
import org.ajax4jsf.io.FastBufferWriter;

public class FastBufferWriterTest
extends TestCase {
    public void testResetOneBuffer() throws Exception {
        FastBufferWriter stream = new FastBufferWriter(256);
        for (int i = 0; i < 255; ++i) {
            stream.write(i);
        }
        FastBufferWriterTest.assertEquals((int)255, (int)stream.getLength());
        CharBuffer firstBuffer = stream.getFirstBuffer();
        FastBufferWriterTest.assertNull((Object)firstBuffer.getNext());
        FastBufferWriterTest.assertNull((Object)firstBuffer.getPrevious());
        stream.reset();
        FastBufferWriterTest.assertEquals((int)0, (int)stream.getLength());
        firstBuffer = stream.getFirstBuffer();
        FastBufferWriterTest.assertEquals((int)0, (int)firstBuffer.getUsedSize());
        FastBufferWriterTest.assertNull((Object)firstBuffer.getNext());
        FastBufferWriterTest.assertNull((Object)firstBuffer.getPrevious());
    }

    public void testResetTwoBuffers() throws Exception {
        FastBufferWriter stream = new FastBufferWriter(256);
        for (int i = 0; i < 257; ++i) {
            stream.write(i);
        }
        FastBufferWriterTest.assertEquals((int)257, (int)stream.getLength());
        CharBuffer firstBuffer = stream.getFirstBuffer();
        FastBufferWriterTest.assertNotNull((Object)firstBuffer.getNext());
        FastBufferWriterTest.assertNull((Object)firstBuffer.getPrevious());
        stream.reset();
        FastBufferWriterTest.assertEquals((int)0, (int)stream.getLength());
        firstBuffer = stream.getFirstBuffer();
        FastBufferWriterTest.assertEquals((int)0, (int)firstBuffer.getUsedSize());
        FastBufferWriterTest.assertNull((Object)firstBuffer.getNext());
        FastBufferWriterTest.assertNull((Object)firstBuffer.getPrevious());
    }

    public void testCompact() throws Exception {
        int itemsTowWrite = 32384;
        FastBufferWriter writer = new FastBufferWriter(16384);
        for (int i = 0; i < itemsTowWrite; ++i) {
            writer.write(i);
        }
        writer.close();
        CharBuffer firstBuffer = writer.getFirstBuffer();
        FastBufferWriterTest.assertNotNull((Object)firstBuffer);
        CharBuffer nextBuffer = firstBuffer.getNext();
        FastBufferWriterTest.assertNotNull((Object)nextBuffer);
        FastBufferWriterTest.assertNull((Object)nextBuffer.getNext());
        FastBufferWriterTest.assertTrue((firstBuffer.getUsedSize() == firstBuffer.getCacheSize() ? 1 : 0) != 0);
        FastBufferWriterTest.assertTrue((nextBuffer.getUsedSize() < nextBuffer.getCacheSize() ? 1 : 0) != 0);
        firstBuffer.compact();
        FastBufferWriterTest.assertTrue((firstBuffer.getUsedSize() == firstBuffer.getCacheSize() ? 1 : 0) != 0);
        FastBufferWriterTest.assertTrue((nextBuffer.getUsedSize() == nextBuffer.getCacheSize() ? 1 : 0) != 0);
        FastBufferReader reader = new FastBufferReader(firstBuffer);
        for (int i = 0; i < itemsTowWrite; ++i) {
            FastBufferWriterTest.assertEquals((int)i, (int)reader.read());
        }
        reader.close();
    }
}

