/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cache;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.test.faces.AbstractFacesTest;
import org.junit.Assert;
import org.richfaces.cache.Cache;
import org.richfaces.cache.CacheManager;

public abstract class BaseCacheTest
extends AbstractFacesTest {
    private int sizeLimit;
    private CacheManager cacheManager;
    private Cache cache;
    private String cacheManagerFactoryClassName;

    public BaseCacheTest(String cacheManagerFactoryClassName) {
        this.cacheManagerFactoryClassName = cacheManagerFactoryClassName;
    }

    protected void setupJsfInitParameters() {
        super.setupJsfInitParameters();
        this.facesServer.addInitParameter("org.richfaces.cache.CACHE_MANAGER_FACTORY_CLASS", this.cacheManagerFactoryClassName);
        this.facesServer.addInitParameter("org.richfaces.resourceCacheSize", Integer.toString(this.sizeLimit));
    }

    protected Cache getCache() {
        return this.cache;
    }

    public void setUp() throws Exception {
        this.sizeLimit = 64;
        super.setUp();
        this.setupFacesRequest();
        this.cacheManager = new CacheManager();
        Map initParameterMap = this.facesContext.getExternalContext().getInitParameterMap();
        this.cache = this.cacheManager.createCache(this.facesContext, "test-cache", initParameterMap);
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.cacheManager.destroy();
    }

    public void testBasic() throws Exception {
        BaseCacheTest.assertNull((Object)this.cache.get((Object)"a"));
        this.cache.put((Object)"a", (Object)"value-a", null);
        BaseCacheTest.assertEquals((Object)"value-a", (Object)this.cache.get((Object)"a"));
    }

    public void testExpiration() throws Exception {
        BaseCacheTest.assertNull((Object)this.cache.get((Object)"a"));
        long sleepTime = 0L;
        long expirationTime = System.currentTimeMillis() + 3000L;
        this.cache.put((Object)"a", (Object)"value-a", new Date(expirationTime));
        BaseCacheTest.assertEquals((Object)"value-a", (Object)this.cache.get((Object)"a"));
        this.cache.put((Object)"b", (Object)"value-b", new Date(expirationTime));
        BaseCacheTest.assertEquals((Object)"value-b", (Object)this.cache.get((Object)"b"));
        sleepTime = expirationTime - 1000L - System.currentTimeMillis();
        BaseCacheTest.assertTrue((sleepTime > 0L ? 1 : 0) != 0);
        Thread.sleep(sleepTime);
        BaseCacheTest.assertEquals((Object)"value-a", (Object)this.cache.get((Object)"a"));
        sleepTime = expirationTime + 1000L - System.currentTimeMillis();
        BaseCacheTest.assertTrue((sleepTime > 0L ? 1 : 0) != 0);
        Thread.sleep(sleepTime);
        BaseCacheTest.assertNull((Object)this.cache.get((Object)"a"));
    }

    public void testMaxSize() throws Exception {
        Date expirationDate = new Date(System.currentTimeMillis() + 3600000L);
        LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
        for (int i = 0; i < this.sizeLimit; ++i) {
            String key = UUID.randomUUID().toString();
            String value = UUID.randomUUID().toString();
            data.put(key, value);
            this.cache.put((Object)key, (Object)value, expirationDate);
        }
        for (Map.Entry entry : data.entrySet()) {
            String key = (String)entry.getKey();
            Object cacheValue = this.cache.get((Object)key);
            BaseCacheTest.assertEquals(entry.getValue(), (Object)cacheValue);
        }
        String extraEntryKey = UUID.randomUUID().toString();
        String extraEntryValue = UUID.randomUUID().toString();
        data.put(extraEntryKey, extraEntryValue);
        this.cache.put((Object)extraEntryKey, (Object)extraEntryValue, expirationDate);
        Thread.sleep(2000L);
        int nullCounter = 0;
        for (Map.Entry entry : data.entrySet()) {
            String key = (String)entry.getKey();
            Object cacheValue = this.cache.get((Object)key);
            if (cacheValue == null) {
                ++nullCounter;
                continue;
            }
            BaseCacheTest.assertEquals(entry.getValue(), (Object)cacheValue);
        }
        BaseCacheTest.assertTrue((nullCounter == 1 ? 1 : 0) != 0);
    }

    public void testThreads() throws Exception {
        final AtomicBoolean failure = new AtomicBoolean();
        Thread[] writerThreads = new Thread[10];
        for (int i = 0; i < writerThreads.length; ++i) {
            writerThreads[i] = new Thread(){

                @Override
                public void run() {
                    final String key = UUID.randomUUID().toString();
                    final String value = UUID.randomUUID().toString();
                    BaseCacheTest.this.cache.put((Object)key, (Object)value, null);
                    Thread[] threads = new Thread[25];
                    for (int j = 0; j < threads.length; ++j) {
                        threads[j] = new Thread(){

                            @Override
                            public void run() {
                                int retries = 1000;
                                for (int k = 0; k < retries; ++k) {
                                    if (value.equals(BaseCacheTest.this.cache.get((Object)key))) continue;
                                    failure.set(true);
                                    return;
                                }
                            }
                        };
                    }
                    for (Thread thread : threads) {
                        thread.start();
                    }
                    int retries = 1000;
                    for (int k = 0; k < retries; ++k) {
                        if (value.equals(BaseCacheTest.this.cache.get((Object)key))) continue;
                        failure.set(true);
                    }
                    for (Thread thread : threads) {
                        try {
                            thread.join();
                        }
                        catch (InterruptedException e) {
                            failure.set(true);
                        }
                    }
                }
            };
        }
        for (Thread thread : writerThreads) {
            thread.start();
        }
        for (Thread thread : writerThreads) {
            thread.join();
        }
        Assert.assertFalse((boolean)failure.get());
    }
}

