/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.jboss.test.faces.FacesEnvironment;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.richfaces.ContextInitParameter;
import org.richfaces.ContextInitParameters;

public class FacesRequestSetupRule
implements MethodRule {
    private FacesEnvironment environment;
    private FacesEnvironment.FacesRequest facesRequest;

    public Statement apply(final Statement base, final FrameworkMethod method, Object target) {
        return new Statement(){

            public void evaluate() throws Throwable {
                FacesRequestSetupRule.this.starting(method);
                try {
                    base.evaluate();
                }
                catch (Throwable t) {
                    throw t;
                }
                finally {
                    FacesRequestSetupRule.this.finished(method);
                }
            }
        };
    }

    private Map<String, String> getInitParameters(FrameworkMethod method) {
        ContextInitParameters parameters;
        HashMap result = Maps.newHashMap();
        ContextInitParameter parameter = (ContextInitParameter)method.getAnnotation(ContextInitParameter.class);
        if (parameter != null) {
            result.put(parameter.name(), parameter.value());
        }
        if ((parameters = (ContextInitParameters)method.getAnnotation(ContextInitParameters.class)) != null) {
            for (ContextInitParameter param : parameters.value()) {
                if (result.put(param.name(), param.value()) == null) continue;
                throw new IllegalArgumentException("Parameter " + param + " specified twice");
            }
        }
        return result;
    }

    protected void starting(FrameworkMethod method) throws Exception {
        this.createFacesEnvironment();
        this.setUpFacesEnvironment(method);
        this.createFacesRequest();
        this.setUpFacesRequest();
    }

    protected void finished(FrameworkMethod method) throws Exception {
        this.tearDownFacesRequest();
        this.tearDownFacesEnvironment();
    }

    protected void setUpFacesRequest() {
        this.facesRequest.start();
    }

    protected void createFacesRequest() throws Exception {
        this.facesRequest = this.environment.createFacesRequest();
    }

    protected void setUpFacesEnvironment(FrameworkMethod method) {
        for (Map.Entry<String, String> paramEntry : this.getInitParameters(method).entrySet()) {
            this.environment.getServer().addInitParameter(paramEntry.getKey(), paramEntry.getValue());
        }
        this.environment.start();
    }

    protected void createFacesEnvironment() {
        this.environment = FacesEnvironment.createEnvironment();
    }

    protected void tearDownFacesEnvironment() {
        if (this.environment != null) {
            this.environment.release();
            this.environment = null;
        }
    }

    protected void tearDownFacesRequest() {
        if (this.facesRequest != null) {
            this.facesRequest.release();
            this.facesRequest = null;
        }
    }

    public FacesEnvironment.FacesRequest getFacesRequest() {
        return this.facesRequest;
    }
}

