/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.context.FacesContext;
import org.richfaces.application.DependencyInjector;
import org.richfaces.application.ServiceTracker;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.resource.BaseResourceWrapper;
import org.richfaces.resource.CompiledCSSResource;
import org.richfaces.resource.DynamicResource;
import org.richfaces.resource.DynamicUserResource;
import org.richfaces.resource.Java2DAnimatedUserResource;
import org.richfaces.resource.Java2DAnimatedUserResourceWrapperImpl;
import org.richfaces.resource.Java2DUserResource;
import org.richfaces.resource.Java2DUserResourceWrapperImpl;
import org.richfaces.resource.ResourceFactory;
import org.richfaces.resource.ResourceKey;
import org.richfaces.resource.ResourceRequestData;
import org.richfaces.resource.ResourceUtils;
import org.richfaces.resource.UserResource;
import org.richfaces.resource.UserResourceWrapperImpl;
import org.richfaces.resource.VersionedResource;
import org.richfaces.resource.external.ExternalResource;
import org.richfaces.resource.external.ExternalResourceTracker;
import org.richfaces.resource.external.ExternalStaticResourceFactory;
import org.richfaces.util.Util;

public class ResourceFactoryImpl
implements ResourceFactory {
    private static final Logger LOGGER = RichfacesLogger.RESOURCE.getLogger();
    private static final Function<Map.Entry<String, String>, MappedResourceData> DYNAMIC_MAPPINGS_DATA_PRODUCER = new Function<Map.Entry<String, String>, MappedResourceData>(){

        public MappedResourceData apply(Map.Entry<String, String> from) {
            String resourceLocation = from.getValue();
            Map<String, String> params = Util.parseResourceParameters(resourceLocation);
            String resourceQualifier = ResourceFactoryImpl.extractParametersFromResourceName(resourceLocation);
            return new MappedResourceData(ResourceKey.create((String)resourceQualifier), params);
        }
    };
    private ResourceHandler defaultHandler;
    private Map<ResourceKey, MappedResourceData> mappedResourceDataMap;
    private ExternalStaticResourceFactory externalStaticResourceFactory;
    private ExternalResourceTracker resourceTracker;

    public ResourceFactoryImpl(ResourceHandler defaultHandler) {
        this.defaultHandler = defaultHandler;
        this.mappedResourceDataMap = ResourceUtils.readMappings(DYNAMIC_MAPPINGS_DATA_PRODUCER, "META-INF/richfaces/resource-mappings.properties");
        this.externalStaticResourceFactory = (ExternalStaticResourceFactory)ServiceTracker.getProxy(ExternalStaticResourceFactory.class);
        this.resourceTracker = (ExternalResourceTracker)ServiceTracker.getProxy(ExternalResourceTracker.class);
    }

    private static String extractParametersFromResourceName(String resourceName) {
        if (resourceName.lastIndexOf("{") == -1) {
            return resourceName;
        }
        return resourceName.substring(0, resourceName.lastIndexOf("{"));
    }

    private void logResourceProblem(FacesContext context, Throwable throwable, String messagePattern, Object ... arguments) {
        boolean isProductionStage = context.isProjectStage(ProjectStage.Production);
        if (LOGGER.isWarnEnabled() || !isProductionStage && LOGGER.isInfoEnabled()) {
            String formattedMessage = MessageFormat.format(messagePattern, arguments);
            if (throwable != null) {
                LOGGER.warn((CharSequence)formattedMessage, throwable);
            } else if (isProductionStage) {
                LOGGER.info((CharSequence)formattedMessage);
            } else {
                LOGGER.warn((CharSequence)formattedMessage);
            }
        }
    }

    private void logMissingResource(FacesContext context, String resourceData) {
        this.logResourceProblem(context, null, "Resource {0} was not found", resourceData);
    }

    private Resource createCompiledCSSResource(ResourceKey resourceKey) {
        Resource sourceResource = this.defaultHandler.createResource(resourceKey.getResourceName(), resourceKey.getLibraryName(), "text/plain");
        if (sourceResource != null) {
            return new CompiledCSSResource(sourceResource);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void injectProperties(Object resource, Map<String, String> parameters) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Map attributes = facesContext.getAttributes();
        try {
            attributes.put("rfResourceParam", parameters);
            ((DependencyInjector)ServiceTracker.getService(DependencyInjector.class)).inject(facesContext, resource);
        }
        finally {
            attributes.remove("rfResourceParam");
        }
    }

    private boolean isCacheableSet(Class<?> c) {
        DynamicUserResource annotation = c.getAnnotation(DynamicUserResource.class);
        return annotation != null && annotation.cacheable();
    }

    private boolean isVersionedSet(Class<?> c) {
        DynamicUserResource annotation = c.getAnnotation(DynamicUserResource.class);
        return annotation != null && annotation.versioned();
    }

    private Resource createDynamicUserResourceInstance(Class<?> loadedClass) throws Exception, LinkageError {
        DynamicResource dynamicResource;
        String resourceName = loadedClass.getName();
        boolean checkResult = false;
        DynamicUserResource dynamicUserResource = loadedClass.getAnnotation(DynamicUserResource.class);
        if (dynamicUserResource != null) {
            checkResult = true;
            LOGGER.debug((CharSequence)MessageFormat.format("Dynamic resource annotation is present on resource class {0}", resourceName));
        }
        if (!checkResult && (dynamicResource = loadedClass.getAnnotation(DynamicResource.class)) != null) {
            LOGGER.debug((CharSequence)MessageFormat.format("Dynamic resource annotation is present on resource class {0}", resourceName));
            checkResult = true;
        }
        if (!checkResult) {
            LOGGER.debug((CharSequence)MessageFormat.format("Dynamic resource annotation is not present on resource class {0}", resourceName));
            checkResult = this.checkResourceMarker(resourceName);
        }
        if (!checkResult) {
            return null;
        }
        Resource result = null;
        if (Java2DUserResource.class.isAssignableFrom(loadedClass)) {
            Java2DUserResource java2DUserResource = (Java2DUserResource)loadedClass.newInstance();
            result = this.createResource(java2DUserResource);
        } else if (UserResource.class.isAssignableFrom(loadedClass)) {
            UserResource userResource = (UserResource)loadedClass.newInstance();
            result = this.createResource(userResource);
        }
        return result;
    }

    private Resource createDynamicResourceInstance(Class<?> loadedClass) throws Exception, LinkageError {
        String resourceName = loadedClass.getName();
        boolean checkResult = false;
        DynamicResource annotation = loadedClass.getAnnotation(DynamicResource.class);
        if (annotation != null) {
            LOGGER.debug((CharSequence)MessageFormat.format("Dynamic resource annotation is present on resource class {0}", resourceName));
            checkResult = true;
        } else {
            LOGGER.debug((CharSequence)MessageFormat.format("Dynamic resource annotation is not present on resource class {0}", resourceName));
        }
        if (!checkResult) {
            checkResult = this.checkResourceMarker(resourceName);
        }
        if (!checkResult) {
            return null;
        }
        Class<Resource> resourceClass = loadedClass.asSubclass(Resource.class);
        Resource result = resourceClass.newInstance();
        return result;
    }

    protected Resource createHandlerDependentResource(ResourceKey resourceKey, Map<String, String> parameters) {
        if (!Strings.isNullOrEmpty((String)resourceKey.getLibraryName())) {
            return null;
        }
        String resourceName = resourceKey.getResourceName();
        Resource resource = null;
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            try {
                Class<?> loadedClass = Class.forName(resourceName, false, contextClassLoader);
                resource = this.createDynamicUserResourceInstance(loadedClass);
                if (resource == null) {
                    resource = this.createDynamicResourceInstance(loadedClass);
                }
                if (resource != null) {
                    resource.setResourceName(resourceName);
                    if (parameters != null) {
                        if (resource instanceof BaseResourceWrapper) {
                            BaseResourceWrapper baseResourceWrapper = (BaseResourceWrapper)resource;
                            this.injectProperties(baseResourceWrapper.getWrapped(), parameters);
                        } else {
                            this.injectProperties(resource, parameters);
                        }
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((CharSequence)MessageFormat.format("Successfully created instance of {0} resource", resourceName));
                    }
                }
            }
            catch (ClassNotFoundException e) {
            }
            catch (Exception e) {
                this.logResourceProblem(FacesContext.getCurrentInstance(), e, "Error creating resource {0}", resourceName);
            }
            catch (LinkageError e) {
                this.logResourceProblem(FacesContext.getCurrentInstance(), e, "Error creating resource {0}", resourceName);
            }
        }
        return resource;
    }

    private boolean checkResourceMarker(String resourceName) {
        boolean result;
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        URL resourceMarkerUrl = contextClassLoader.getResource("META-INF/" + resourceName + ".resource.properties");
        boolean bl = result = resourceMarkerUrl != null;
        if (LOGGER.isDebugEnabled()) {
            if (result) {
                LOGGER.debug((CharSequence)MessageFormat.format("Marker file for {0} resource found in classpath", resourceName));
            } else {
                LOGGER.debug((CharSequence)MessageFormat.format("Marker file for {0} resource does not exist", resourceName));
            }
        }
        return result;
    }

    public Resource createResource(FacesContext context, ResourceRequestData resourceData) {
        String resourceName = resourceData.getResourceName();
        if (resourceName == null || resourceName.length() == 0) {
            return null;
        }
        String libraryName = resourceData.getLibraryName();
        Resource resource = this.createDynamicResource(new ResourceKey(resourceName, libraryName), false);
        if (resource == null) {
            this.logMissingResource(context, resourceData.getResourceKey());
            return null;
        }
        if (resource instanceof VersionedResource) {
            VersionedResource versionedResource = (VersionedResource)resource;
            String existingVersion = versionedResource.getVersion();
            String requestedVersion = resourceData.getVersion();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((CharSequence)MessageFormat.format("Client requested {0} version of resource, server has {1} version", String.valueOf(requestedVersion), String.valueOf(existingVersion)));
            }
            if (existingVersion != null && requestedVersion != null && !existingVersion.equals(requestedVersion)) {
                this.logResourceProblem(context, null, "Resource {0} of version {1} was not found", resourceName, requestedVersion);
                return null;
            }
        }
        Object decodedData = resourceData.getData();
        if (LOGGER.isDebugEnabled()) {
            if (decodedData != null) {
                LOGGER.debug((CharSequence)"Resource state data succesfully decoded");
            } else {
                LOGGER.debug((CharSequence)"Resource state data decoded as null");
            }
        }
        Util.restoreResourceState(context, resource, decodedData);
        return resource;
    }

    public Resource createResource(String resourceName, String libraryName, String contentType) {
        ResourceKey resourceKey = new ResourceKey(resourceName, libraryName);
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalResource externalResource = this.externalStaticResourceFactory.createResource(facesContext, resourceKey);
        if (externalResource != null) {
            this.resourceTracker.markExternalResourceRendered(facesContext, externalResource);
            return externalResource;
        }
        return this.createDynamicResource(resourceKey, true);
    }

    protected Resource createDynamicResource(ResourceKey resourceKey, boolean useDependencyInjection) {
        ResourceKey actualKey;
        Resource result = null;
        Map<String, String> params = null;
        MappedResourceData mappedResourceData = this.mappedResourceDataMap.get(resourceKey);
        if (mappedResourceData != null) {
            actualKey = mappedResourceData.getResourceKey();
            if (useDependencyInjection) {
                params = mappedResourceData.getParams();
            }
        } else {
            actualKey = resourceKey;
            if (useDependencyInjection) {
                params = Collections.emptyMap();
            }
        }
        if (Strings.isNullOrEmpty((String)resourceKey.getResourceName())) {
            return null;
        }
        result = actualKey.getResourceName().endsWith(".ecss") ? this.createCompiledCSSResource(actualKey) : this.createHandlerDependentResource(actualKey, params);
        if (result != null) {
            result.setLibraryName(resourceKey.getLibraryName());
            result.setResourceName(resourceKey.getResourceName());
        } else if (mappedResourceData != null) {
            result = this.defaultHandler.createResource(actualKey.getResourceName(), actualKey.getLibraryName());
        }
        return result;
    }

    public Collection<ResourceKey> getMappedDynamicResourceKeys() {
        return Collections.unmodifiableSet(this.mappedResourceDataMap.keySet());
    }

    protected Resource createResource(Java2DUserResource resource) {
        boolean cacheable = this.isCacheableSet(resource.getClass());
        boolean versioned = this.isVersionedSet(resource.getClass());
        if (resource instanceof Java2DAnimatedUserResource) {
            Java2DAnimatedUserResource java2DAnimatedUserResource = (Java2DAnimatedUserResource)resource;
            return new Java2DAnimatedUserResourceWrapperImpl(java2DAnimatedUserResource, cacheable, versioned);
        }
        return new Java2DUserResourceWrapperImpl(resource, cacheable, versioned);
    }

    protected Resource createResource(UserResource resource) {
        boolean cacheable = this.isCacheableSet(resource.getClass());
        boolean versioned = this.isVersionedSet(resource.getClass());
        return new UserResourceWrapperImpl(resource, cacheable, versioned);
    }

    private static class MappedResourceData {
        private ResourceKey resourceKey;
        private Map<String, String> params;

        public MappedResourceData(ResourceKey resourceKey, Map<String, String> params) {
            this.resourceKey = resourceKey;
            this.params = params;
        }

        public ResourceKey getResourceKey() {
            return this.resourceKey;
        }

        public Map<String, String> getParams() {
            return this.params;
        }
    }
}

