/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.Collection;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.javascript.ScriptUtils;
import org.richfaces.component.UIScripts;
import org.richfaces.renderkit.html.ResourceRenderer;
import org.richfaces.resource.ResourceKey;

public class ScriptsRenderer
extends ResourceRenderer {
    public static final String RENDERER_TYPE = "org.richfaces.renderer.ScriptsRenderer";
    private static final String TEXT_JAVASCRIPT = "text/javascript";
    private static final String SRC = "src";
    private static final String TYPE = "type";
    private static final String SCRIPT = "script";
    private static final ResourceKey JQUERY = ResourceKey.create((String)"jquery.js", null);

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        UIScripts validatorScript = (UIScripts)component;
        ResponseWriter responseWriter = context.getResponseWriter();
        Collection<Object> scripts = validatorScript.getScripts();
        this.encodeDependentResources(context, component, scripts);
        Collection<Object> pageReadyScripts = validatorScript.getPageReadyScripts();
        if (!pageReadyScripts.isEmpty()) {
            this.encodeResource(component, context, JQUERY);
            this.encodeDependentResources(context, component, pageReadyScripts);
        }
        responseWriter.startElement(SCRIPT, null);
        responseWriter.writeAttribute(TYPE, (Object)TEXT_JAVASCRIPT, null);
        for (Object script : scripts) {
            ScriptUtils.writeToStream((ResponseWriter)responseWriter, (Object)script);
            responseWriter.writeText((Object)"\n", null);
        }
        if (!pageReadyScripts.isEmpty()) {
            responseWriter.writeText((Object)"$(document).ready(function() {\n", null);
            for (Object script : pageReadyScripts) {
                ScriptUtils.writeToStream((ResponseWriter)responseWriter, (Object)script);
                responseWriter.writeText((Object)"\n", null);
            }
            responseWriter.writeText((Object)"});\n", null);
        }
        responseWriter.endElement(SCRIPT);
    }
}

