/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.skin;

import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.ajax4jsf.Messages;
import org.richfaces.skin.AbstractSkin;
import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinFactory;

final class SkinImpl
extends AbstractSkin {
    private static final Operation RESOLVE = new Operation(){

        @Override
        public Object executeLocal(FacesContext facesContext, SkinImpl skin, String name) {
            String string;
            Object resolvedParameter = skin.getLocalParameter(facesContext, name);
            while (resolvedParameter instanceof String && (string = (String)resolvedParameter).length() > 0 && string.charAt(0) == '&') {
                SkinFactory skinFactory = SkinFactory.getInstance((FacesContext)facesContext);
                resolvedParameter = skinFactory.getSkin(facesContext).getParameter(facesContext, string.substring(1));
                if (resolvedParameter != null) continue;
                throw new FacesException(Messages.getMessage((String)"SKIN_ILLEGAL_REFERENCE", (Object)name));
            }
            return resolvedParameter;
        }

        @Override
        public Object executeBase(FacesContext facesContext, Skin skin, String name) {
            return skin.getParameter(facesContext, name);
        }
    };
    private static final Operation CONTAINS = new Operation(){

        @Override
        public Object executeLocal(FacesContext facesContext, SkinImpl skin, String name) {
            return skin.localContainsProperty(facesContext, name) ? Boolean.TRUE : Boolean.FALSE;
        }

        @Override
        public Object executeBase(FacesContext facesContext, Skin skin, String name) {
            return skin.containsProperty(name);
        }
    };
    private final Map<Object, Object> skinParams;
    private String name;

    SkinImpl(Map<Object, Object> properties, String name) {
        this.skinParams = properties;
        this.name = name;
    }

    private MutableInteger getCounter(FacesContext context) {
        Map attr = context.getAttributes();
        MutableInteger counter = (MutableInteger)attr.get(MutableInteger.class);
        if (counter == null) {
            counter = new MutableInteger();
            attr.put(MutableInteger.class, counter);
        }
        return counter;
    }

    protected Map<Object, Object> getSkinParams() {
        return this.skinParams;
    }

    public Object getParameter(FacesContext context, String name) {
        return this.getValueReference(context, this.resolveSkinParameter(context, name));
    }

    public Object getParameter(FacesContext context, String name, Object defaultValue) {
        Object value = this.getValueReference(context, this.resolveSkinParameter(context, name));
        if (null == value) {
            value = defaultValue;
        }
        return value;
    }

    protected Object getLocalParameter(FacesContext context, String name) {
        return this.getValueReference(context, this.skinParams.get(name));
    }

    protected Object getValueReference(FacesContext context, Object property) {
        if (property instanceof ValueExpression) {
            ValueExpression value = (ValueExpression)property;
            return value.getValue(context.getELContext());
        }
        return property;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.skinParams.toString();
    }

    protected Skin getBaseSkin(FacesContext context) {
        String baseSkinName = (String)this.getLocalParameter(context, "baseSkin");
        if (baseSkinName != null) {
            SkinFactory skinFactory = SkinFactory.getInstance((FacesContext)context);
            return skinFactory.getSkin(context, baseSkinName);
        }
        return null;
    }

    protected Object localResolveSkinParameter(FacesContext context, String name) {
        return this.getSkinParams().get(name);
    }

    protected boolean localContainsProperty(FacesContext context, String name) {
        return this.getSkinParams().containsKey(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object executeOperation(FacesContext context, Operation operation, String name) {
        MutableInteger counter = this.getCounter(context);
        try {
            if (counter.getAndIncrement() > 100) {
                throw new FacesException(Messages.getMessage((String)"SKIN_CYCLIC_REFERENCE", (Object)name));
            }
            Object result = operation.executeLocal(context, this, name);
            if (result != null) {
                Object object = result;
                return object;
            }
            Skin baseSkin = this.getBaseSkin(context);
            if (baseSkin != null) {
                Object object = operation.executeBase(context, baseSkin, name);
                return object;
            }
        }
        finally {
            counter.getAndDecrement();
        }
        return null;
    }

    protected boolean containsProperty(FacesContext context, String name) {
        return Boolean.TRUE.equals(this.executeOperation(context, CONTAINS, name));
    }

    protected Object resolveSkinParameter(FacesContext context, String name) {
        return this.executeOperation(context, RESOLVE, name);
    }

    public boolean containsProperty(String name) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return this.containsProperty(facesContext, name);
    }

    public String getName() {
        return this.name;
    }

    public int hashCode(FacesContext context) {
        int hash = 0;
        for (Map.Entry<Object, Object> entry : this.skinParams.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            Object parameter = this.getValueReference(context, value);
            hash = 31 * hash + key.hashCode();
            hash = 31 * hash + (parameter != null ? parameter.hashCode() : 0);
        }
        Skin baseSkin = this.getBaseSkin(context);
        if (baseSkin != null) {
            hash = 31 * hash + baseSkin.hashCode(context);
        }
        return hash;
    }

    private static abstract class Operation {
        private Operation() {
        }

        public abstract Object executeLocal(FacesContext var1, SkinImpl var2, String var3);

        public abstract Object executeBase(FacesContext var1, Skin var2, String var3);
    }

    private static class MutableInteger {
        private int value;

        private MutableInteger() {
        }

        public int getAndIncrement() {
            return this.value++;
        }

        public int getAndDecrement() {
            return this.value--;
        }
    }
}

