/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.log;

import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.richfaces.l10n.BundleLoader;
import org.richfaces.l10n.InterpolationException;
import org.richfaces.l10n.MessageInterpolator;
import org.richfaces.log.Logger;

public class JavaLogger
implements Logger {
    public static final String RICHFACES_LOG = "org.richfaces";
    static final Map<Logger.Level, Level> LEVELS_MAP = new EnumMap<Logger.Level, Level>(Logger.Level.class);
    private static final String CLASS_NAME;
    private final java.util.logging.Logger jdkLogger;
    private MessageInterpolator messageInterpolator;

    JavaLogger(String category) {
        this.jdkLogger = java.util.logging.Logger.getLogger(category);
        this.messageInterpolator = new MessageInterpolator(new BundleLoader());
    }

    JavaLogger() {
        this(RICHFACES_LOG);
    }

    private void fillCallerData(String fqn, LogRecord record) {
        int idx;
        StackTraceElement[] stackTrace = new Exception().getStackTrace();
        for (int i = 0; i < stackTrace.length && !fqn.equals(stackTrace[i].getClassName()); ++i) {
        }
        for (idx = i + 1; idx < stackTrace.length && fqn.equals(stackTrace[idx].getClassName()); ++idx) {
        }
        if (idx < stackTrace.length) {
            record.setSourceMethodName(stackTrace[idx].getMethodName());
            record.setSourceClassName(stackTrace[idx].getClassName());
        }
    }

    private String interpolate(Enum<?> messageKey, Object ... args) {
        try {
            return this.messageInterpolator.interpolate(Locale.getDefault(), messageKey, args);
        }
        catch (InterpolationException e) {
            return "???" + e.getMessageKey() + "???";
        }
    }

    private LogRecord createRecord(Level level, CharSequence message, Throwable thrown) {
        LogRecord record = new LogRecord(level, message != null ? ((Object)message).toString() : null);
        record.setLoggerName(this.jdkLogger.getName());
        record.setThrown(thrown);
        this.fillCallerData(CLASS_NAME, record);
        return record;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isLogEnabled(Logger.Level.DEBUG);
    }

    @Override
    public void debug(CharSequence content) {
        this.log(Logger.Level.DEBUG, content);
    }

    @Override
    public void debug(Enum<?> messageKey, Object ... args) {
        this.log(Logger.Level.DEBUG, messageKey, args);
    }

    @Override
    public void debug(CharSequence content, Throwable thrown) {
        this.log(Logger.Level.DEBUG, content, thrown);
    }

    @Override
    public void debug(Throwable error, Enum<?> messageKey, Object ... args) {
        this.log(Logger.Level.DEBUG, error, messageKey, args);
    }

    @Override
    public void debug(Throwable thrown) {
        this.log(Logger.Level.DEBUG, thrown);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isLogEnabled(Logger.Level.INFO);
    }

    @Override
    public void info(CharSequence content) {
        this.log(Logger.Level.INFO, content);
    }

    @Override
    public void info(Enum<?> messageKey, Object ... args) {
        this.log(Logger.Level.INFO, messageKey, args);
    }

    @Override
    public void info(CharSequence content, Throwable thrown) {
        this.log(Logger.Level.INFO, content, thrown);
    }

    @Override
    public void info(Throwable error, Enum<?> messageKey, Object ... args) {
        this.log(Logger.Level.INFO, error, messageKey, args);
    }

    @Override
    public void info(Throwable thrown) {
        this.log(Logger.Level.INFO, thrown);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isLogEnabled(Logger.Level.WARNING);
    }

    @Override
    public void warn(CharSequence content) {
        this.log(Logger.Level.WARNING, content);
    }

    @Override
    public void warn(Enum<?> messageKey, Object ... args) {
        this.log(Logger.Level.WARNING, messageKey, args);
    }

    @Override
    public void warn(CharSequence content, Throwable thrown) {
        this.log(Logger.Level.WARNING, content, thrown);
    }

    @Override
    public void warn(Throwable error, Enum<?> messageKey, Object ... args) {
        this.log(Logger.Level.WARNING, error, messageKey, args);
    }

    @Override
    public void warn(Throwable thrown) {
        this.log(Logger.Level.WARNING, thrown);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.isLogEnabled(Logger.Level.ERROR);
    }

    @Override
    public void error(CharSequence content) {
        this.log(Logger.Level.ERROR, content);
    }

    @Override
    public void error(Enum<?> messageKey, Object ... args) {
        this.log(Logger.Level.ERROR, messageKey, args);
    }

    @Override
    public void error(CharSequence content, Throwable thrown) {
        this.log(Logger.Level.ERROR, content, thrown);
    }

    @Override
    public void error(Throwable error, Enum<?> messageKey, Object ... args) {
        this.log(Logger.Level.ERROR, error, messageKey, args);
    }

    @Override
    public void error(Throwable thrown) {
        this.log(Logger.Level.ERROR, thrown);
    }

    @Override
    public boolean isLogEnabled(Logger.Level level) {
        return this.jdkLogger.isLoggable(LEVELS_MAP.get((Object)level));
    }

    @Override
    public void log(Logger.Level level, CharSequence content) {
        Level julLevel = LEVELS_MAP.get((Object)level);
        if (this.jdkLogger.isLoggable(julLevel)) {
            this.jdkLogger.log(this.createRecord(julLevel, content, null));
        }
    }

    @Override
    public void log(Logger.Level level, Enum<?> messageKey, Object ... args) {
        Level julLevel = LEVELS_MAP.get((Object)level);
        if (this.jdkLogger.isLoggable(julLevel)) {
            this.jdkLogger.log(this.createRecord(julLevel, this.interpolate(messageKey, args), null));
        }
    }

    @Override
    public void log(Logger.Level level, CharSequence content, Throwable thrown) {
        Level julLevel = LEVELS_MAP.get((Object)level);
        if (this.jdkLogger.isLoggable(julLevel)) {
            this.jdkLogger.log(this.createRecord(julLevel, content, thrown));
        }
    }

    @Override
    public void log(Logger.Level level, Throwable thrown, Enum<?> messageKey, Object ... args) {
        Level julLevel = LEVELS_MAP.get((Object)level);
        if (this.jdkLogger.isLoggable(julLevel)) {
            this.jdkLogger.log(this.createRecord(julLevel, this.interpolate(messageKey, args), thrown));
        }
    }

    @Override
    public void log(Logger.Level level, Throwable thrown) {
        Level julLevel = LEVELS_MAP.get((Object)level);
        if (this.jdkLogger.isLoggable(julLevel)) {
            this.jdkLogger.log(this.createRecord(julLevel, null, thrown));
        }
    }

    static {
        LEVELS_MAP.put(Logger.Level.ERROR, Level.SEVERE);
        LEVELS_MAP.put(Logger.Level.INFO, Level.INFO);
        LEVELS_MAP.put(Logger.Level.WARNING, Level.WARNING);
        LEVELS_MAP.put(Logger.Level.DEBUG, Level.FINE);
        CLASS_NAME = JavaLogger.class.getName();
    }
}

