/*
 * Decompiled with CFR 0.152.
 */
package org.pf4j.spring;

import java.util.List;
import java.util.Set;
import org.pf4j.PluginManager;
import org.pf4j.PluginWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;

public class ExtensionsInjector {
    private static final Logger log = LoggerFactory.getLogger(ExtensionsInjector.class);
    protected final PluginManager pluginManager;
    protected final AbstractAutowireCapableBeanFactory beanFactory;

    public ExtensionsInjector(PluginManager pluginManager, AbstractAutowireCapableBeanFactory beanFactory) {
        this.pluginManager = pluginManager;
        this.beanFactory = beanFactory;
    }

    public void injectExtensions() {
        Set extensionClassNames = this.pluginManager.getExtensionClassNames(null);
        for (String extensionClassName : extensionClassNames) {
            try {
                log.debug("Register extension '{}' as bean", (Object)extensionClassName);
                Class<?> extensionClass = this.getClass().getClassLoader().loadClass(extensionClassName);
                this.registerExtension(extensionClass);
            }
            catch (ClassNotFoundException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        List startedPlugins = this.pluginManager.getStartedPlugins();
        for (PluginWrapper plugin : startedPlugins) {
            log.debug("Registering extensions of the plugin '{}' as beans", (Object)plugin.getPluginId());
            extensionClassNames = this.pluginManager.getExtensionClassNames(plugin.getPluginId());
            for (String extensionClassName : extensionClassNames) {
                try {
                    log.debug("Register extension '{}' as bean", (Object)extensionClassName);
                    Class<?> extensionClass = plugin.getPluginClassLoader().loadClass(extensionClassName);
                    this.registerExtension(extensionClass);
                }
                catch (ClassNotFoundException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    protected void registerExtension(Class<?> extensionClass) {
        Object extension = this.pluginManager.getExtensionFactory().create(extensionClass);
        this.beanFactory.registerSingleton(extension.getClass().getName(), extension);
    }
}

