/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.swissbox.extender;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.swissbox.extender.BundleScanner;
import org.ops4j.pax.swissbox.extender.ManifestEntry;
import org.ops4j.pax.swissbox.extender.ManifestFilter;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleManifestScanner
implements BundleScanner<ManifestEntry> {
    private ManifestFilter m_manifestFilter;

    public BundleManifestScanner(ManifestFilter manifestFilter) {
        NullArgumentException.validateNotNull((Object)manifestFilter, (String)"Dictionary filter");
        this.m_manifestFilter = manifestFilter;
    }

    @Override
    public List<ManifestEntry> scan(Bundle bundle) {
        NullArgumentException.validateNotNull((Object)bundle, (String)"Bundle");
        Dictionary bundleHeaders = bundle.getHeaders();
        if (bundleHeaders != null && !bundleHeaders.isEmpty()) {
            return BundleManifestScanner.asManifestEntryList(this.m_manifestFilter.match(BundleManifestScanner.dictionaryToMap(bundleHeaders)));
        }
        return Collections.emptyList();
    }

    private static List<ManifestEntry> asManifestEntryList(Map<String, String> entries) {
        ArrayList<ManifestEntry> manifestEntries = new ArrayList<ManifestEntry>();
        if (entries != null && !entries.isEmpty()) {
            for (Map.Entry<String, String> entry : entries.entrySet()) {
                manifestEntries.add(new ManifestEntry(entry.getKey(), entry.getValue()));
            }
        }
        return manifestEntries;
    }

    private static Map<String, String> dictionaryToMap(Dictionary dictionary) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            if (dictionary instanceof Hashtable) {
                map.putAll((Hashtable)dictionary);
            } else {
                Enumeration keys = dictionary.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    map.put(key, (String)dictionary.get(key));
                }
            }
            return map;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Dictionary entries must have String keys and values");
        }
    }
}

