/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.param;

import java.util.regex.Pattern;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.Constraint;

public class RegexConstraint
implements Constraint<String> {
    private final Pattern pattern;

    public RegexConstraint(String pattern) {
        Assert.notNull(pattern, "Pattern must not be null.");
        this.pattern = Pattern.compile(pattern);
    }

    @Override
    public boolean isSatisfiedBy(Rewrite event, EvaluationContext context, String value) {
        return value != null && this.pattern.matcher(value).matches();
    }

    public String toString() {
        return this.getPattern();
    }

    public String getPattern() {
        return this.pattern.pattern();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pattern.pattern() == null ? 0 : this.pattern.pattern().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegexConstraint other = (RegexConstraint)obj;
        return !(this.pattern.pattern() == null ? other.pattern.pattern() != null : !this.pattern.pattern().equals(other.pattern.pattern()));
    }
}

