/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.param;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ocpsoft.common.services.ServiceLoader;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.common.util.Iterators;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.param.Parameter;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.spi.GlobalParameterProvider;
import org.ocpsoft.rewrite.util.ServiceLogger;

public class DefaultParameterStore
implements ParameterStore {
    private final Map<String, Parameter<?>> parameters = new LinkedHashMap();
    private static List<GlobalParameterProvider> providers;
    private static final Logger log;

    public DefaultParameterStore() {
        if (providers == null) {
            providers = Iterators.asList(ServiceLoader.load(GlobalParameterProvider.class));
            ServiceLogger.logLoadedServices(log, GlobalParameterProvider.class, providers);
        }
        for (GlobalParameterProvider provider : providers) {
            Set<Parameter<?>> params = provider.getParameters();
            if (params == null) continue;
            for (Parameter<?> parameter : params) {
                this.store(parameter);
            }
        }
    }

    @Override
    public Parameter<?> get(String name, Parameter<?> deflt) {
        Parameter<?> parameter = null;
        if (this.parameters.get(name) != null) {
            parameter = this.parameters.get(name);
        } else {
            parameter = deflt;
            this.parameters.put(name, parameter);
        }
        if (parameter == null) {
            throw new IllegalArgumentException("No such parameter [" + name + "] exists in parameter store.");
        }
        return parameter;
    }

    @Override
    public Parameter<?> get(String name) {
        if (!this.parameters.containsKey(name)) {
            throw new IllegalArgumentException("No such parameter [" + name + "] exists in parameter store.");
        }
        return this.parameters.get(name);
    }

    @Override
    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }

    public Parameter<?> store(Parameter<?> value) {
        Assert.notNull(value, "Parameter to store must not be null.");
        return this.parameters.put(value.getName(), value);
    }

    @Override
    public int size() {
        return this.parameters.size();
    }

    @Override
    public Iterator<Map.Entry<String, Parameter<?>>> iterator() {
        return this.parameters.entrySet().iterator();
    }

    @Override
    public boolean contains(String name) {
        return this.parameters.containsKey(name);
    }

    public String toString() {
        return this.parameters.keySet().toString();
    }

    public static ParameterStore getInstance(EvaluationContext context) throws IllegalStateException {
        ParameterStore store = (ParameterStore)context.get(ParameterStore.class);
        if (store == null) {
            throw new IllegalStateException("Could not retrieve " + ParameterStore.class.getName() + " from " + EvaluationContext.class.getName() + ". Has the " + EvaluationContext.class.getSimpleName() + " been set up properly?");
        }
        return store;
    }

    static {
        log = Logger.getLogger(DefaultParameterStore.class);
    }
}

