/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.ocpsoft.common.pattern.WeightedComparator;
import org.ocpsoft.common.services.ServiceLoader;
import org.ocpsoft.common.spi.ServiceEnricher;
import org.ocpsoft.common.util.Iterators;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.config.ConfigurationProvider;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.servlet.event.BaseRewrite;
import org.ocpsoft.rewrite.servlet.event.InboundServletRewrite;
import org.ocpsoft.rewrite.servlet.impl.RewriteContextImpl;
import org.ocpsoft.rewrite.servlet.spi.ContextListener;
import org.ocpsoft.rewrite.servlet.spi.InboundRewriteProducer;
import org.ocpsoft.rewrite.servlet.spi.OutboundRewriteProducer;
import org.ocpsoft.rewrite.servlet.spi.RequestCycleWrapper;
import org.ocpsoft.rewrite.servlet.spi.RequestListener;
import org.ocpsoft.rewrite.servlet.spi.RequestParameterProvider;
import org.ocpsoft.rewrite.servlet.spi.RewriteLifecycleListener;
import org.ocpsoft.rewrite.spi.ExpressionLanguageProvider;
import org.ocpsoft.rewrite.spi.InvocationResultHandler;
import org.ocpsoft.rewrite.spi.RewriteProvider;
import org.ocpsoft.rewrite.util.ServiceLogger;

public class RewriteFilter
implements Filter {
    Logger log = Logger.getLogger(RewriteFilter.class);
    private List<RewriteLifecycleListener<Rewrite>> listeners;
    private List<RequestCycleWrapper<ServletRequest, ServletResponse>> wrappers;
    private List<RewriteProvider<Rewrite>> providers;
    private List<InboundRewriteProducer<ServletRequest, ServletResponse>> inbound;
    private List<OutboundRewriteProducer<ServletRequest, ServletResponse, Object>> outbound;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.log.info("RewriteFilter starting up...");
        this.listeners = Iterators.asUniqueList(ServiceLoader.load(RewriteLifecycleListener.class));
        this.wrappers = Iterators.asUniqueList(ServiceLoader.load(RequestCycleWrapper.class));
        this.providers = Iterators.asUniqueList(ServiceLoader.load(RewriteProvider.class));
        this.inbound = Iterators.asUniqueList(ServiceLoader.load(InboundRewriteProducer.class));
        this.outbound = Iterators.asUniqueList(ServiceLoader.load(OutboundRewriteProducer.class));
        Collections.sort(this.listeners, new WeightedComparator());
        Collections.sort(this.wrappers, new WeightedComparator());
        Collections.sort(this.providers, new WeightedComparator());
        Collections.sort(this.inbound, new WeightedComparator());
        Collections.sort(this.outbound, new WeightedComparator());
        ServiceLogger.logLoadedServices(this.log, RewriteLifecycleListener.class, this.listeners);
        ServiceLogger.logLoadedServices(this.log, RequestCycleWrapper.class, this.wrappers);
        ServiceLogger.logLoadedServices(this.log, RewriteProvider.class, this.providers);
        ServiceLogger.logLoadedServices(this.log, InboundRewriteProducer.class, this.inbound);
        ServiceLogger.logLoadedServices(this.log, OutboundRewriteProducer.class, this.outbound);
        ServiceLogger.logLoadedServices(this.log, ContextListener.class, Iterators.asUniqueList(ServiceLoader.load(ContextListener.class)));
        ServiceLogger.logLoadedServices(this.log, RequestListener.class, Iterators.asUniqueList(ServiceLoader.load(RequestListener.class)));
        ServiceLogger.logLoadedServices(this.log, RequestParameterProvider.class, Iterators.asUniqueList(ServiceLoader.load(RequestParameterProvider.class)));
        ServiceLogger.logLoadedServices(this.log, ExpressionLanguageProvider.class, Iterators.asUniqueList(ServiceLoader.load(ExpressionLanguageProvider.class)));
        ServiceLogger.logLoadedServices(this.log, InvocationResultHandler.class, Iterators.asUniqueList(ServiceLoader.load(InvocationResultHandler.class)));
        ServiceLogger.logLoadedServices(this.log, ServiceEnricher.class, Iterators.asUniqueList(ServiceLoader.load(ServiceEnricher.class)));
        List configurations = Iterators.asUniqueList(ServiceLoader.load(ConfigurationProvider.class));
        ServiceLogger.logLoadedServices(this.log, ConfigurationProvider.class, configurations);
        if (configurations == null || configurations.isEmpty()) {
            this.log.warn("No ConfigurationProviders were registered: Rewrite will not be enabled on this application. Did you forget to create a '/META-INF/services/" + ConfigurationProvider.class.getName() + " file containing the fully qualified name of your provider implementation?");
        }
        this.log.info("RewriteFilter initialized.");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        InboundServletRewrite<ServletRequest, ServletResponse> event = this.createRewriteEvent(request, response);
        if (event == null) {
            this.log.warn("No Rewrite event was produced - RewriteFilter disabled on this request.");
            chain.doFilter(request, response);
        } else {
            if (request.getAttribute("_com.ocpsoft.rewrite.RequestContext") == null) {
                RewriteContextImpl context = new RewriteContextImpl(this.inbound, this.outbound, this.listeners, this.wrappers, this.providers);
                request.setAttribute("_com.ocpsoft.rewrite.RequestContext", (Object)context);
            }
            for (RewriteLifecycleListener<Rewrite> rewriteLifecycleListener : this.listeners) {
                if (!rewriteLifecycleListener.handles(event)) continue;
                rewriteLifecycleListener.beforeInboundLifecycle(event);
            }
            for (RequestCycleWrapper requestCycleWrapper : this.wrappers) {
                if (!requestCycleWrapper.handles(event)) continue;
                event.setRequest((ServletRequest)requestCycleWrapper.wrapRequest(event.getRequest(), event.getResponse()));
                event.setResponse((ServletResponse)requestCycleWrapper.wrapResponse(event.getRequest(), event.getResponse()));
            }
            this.rewrite(event);
            if (!event.getFlow().is(BaseRewrite.Flow.ABORT_REQUEST)) {
                this.log.debug("RewriteFilter passing control of request to underlying application.");
                chain.doFilter(event.getRequest(), event.getResponse());
                this.log.debug("Control of request returned to RewriteFilter.");
            }
            for (RewriteLifecycleListener rewriteLifecycleListener : this.listeners) {
                if (!rewriteLifecycleListener.handles(event)) continue;
                rewriteLifecycleListener.afterInboundLifecycle(event);
            }
        }
    }

    public InboundServletRewrite<ServletRequest, ServletResponse> createRewriteEvent(ServletRequest request, ServletResponse response) {
        for (InboundRewriteProducer<ServletRequest, ServletResponse> producer : this.inbound) {
            InboundServletRewrite<ServletRequest, ServletResponse> event = producer.createInboundRewrite(request, response);
            if (event == null) continue;
            return event;
        }
        return null;
    }

    private void rewrite(InboundServletRewrite<ServletRequest, ServletResponse> event) throws ServletException, IOException {
        for (RewriteLifecycleListener<Rewrite> rewriteLifecycleListener : this.listeners) {
            if (!rewriteLifecycleListener.handles(event)) continue;
            rewriteLifecycleListener.beforeInboundRewrite(event);
        }
        for (RewriteProvider rewriteProvider : this.providers) {
            if (!rewriteProvider.handles(event)) continue;
            rewriteProvider.rewrite(event);
            if (!event.getFlow().is(BaseRewrite.Flow.HANDLED)) continue;
            this.log.debug("Event flow marked as HANDLED. No further processing will occur.");
            break;
        }
        for (RewriteLifecycleListener rewriteLifecycleListener : this.listeners) {
            if (!rewriteLifecycleListener.handles(event)) continue;
            rewriteLifecycleListener.afterInboundRewrite(event);
        }
        if (event.getFlow().is(BaseRewrite.Flow.ABORT_REQUEST)) {
            HttpServletResponse response;
            if (event.getFlow().is(BaseRewrite.Flow.FORWARD)) {
                this.log.debug("Issuing internal FORWARD to [{}].", event.getDispatchResource());
                event.getRequest().getRequestDispatcher(event.getDispatchResource()).forward(event.getRequest(), event.getResponse());
            } else if (event.getFlow().is(BaseRewrite.Flow.REDIRECT_PERMANENT)) {
                this.log.debug("Issuing 301 permanent REDIRECT to [{}].", event.getDispatchResource());
                response = (HttpServletResponse)event.getResponse();
                response.setStatus(301);
                response.setHeader("Location", event.getDispatchResource());
                response.flushBuffer();
            } else if (event.getFlow().is(BaseRewrite.Flow.REDIRECT_TEMPORARY)) {
                this.log.debug("Issuing 302 temporary REDIRECT to [{}].", event.getDispatchResource());
                response = (HttpServletResponse)event.getResponse();
                response.setStatus(302);
                response.setHeader("Location", event.getDispatchResource());
                response.flushBuffer();
            } else {
                this.log.debug("ABORT requested. Terminating request NOW.");
            }
        } else if (event.getFlow().is(BaseRewrite.Flow.INCLUDE)) {
            this.log.debug("Issuing internal INCLUDE to [{}].", event.getDispatchResource());
            event.getRequest().getRequestDispatcher(event.getDispatchResource()).include(event.getRequest(), event.getResponse());
        }
    }

    public void destroy() {
        this.log.info("RewriteFilter shutting down...");
        this.log.info("RewriteFilter deactivated.");
    }
}

