/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.faces.annotation.config;

import javax.faces.context.FacesContext;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;

public class IgnorePostbackBinding
implements Binding {
    private final Binding delegate;

    public IgnorePostbackBinding(Binding delegate) {
        this.delegate = delegate;
    }

    public Object retrieve(Rewrite event, EvaluationContext context) {
        if (!this.isPostback()) {
            return this.delegate.retrieve(event, context);
        }
        return null;
    }

    public Object submit(Rewrite event, EvaluationContext context, Object value) {
        if (!this.isPostback()) {
            return this.delegate.submit(event, context, value);
        }
        return null;
    }

    public boolean supportsRetrieval() {
        return this.delegate.supportsRetrieval();
    }

    public boolean supportsSubmission() {
        return this.delegate.supportsSubmission();
    }

    private boolean isPostback() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Assert.notNull((Object)facesContext, (String)"FacesContext.getCurrentInstance() returned null. You should use @Deferred so the binding gets executed within the JSF lifecycle.");
        return facesContext.getRenderKit().getResponseStateManager().isPostback(facesContext);
    }
}

