/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.undertow;

import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.util.ImmediateInstanceFactory;
import javax.servlet.ServletContext;
import org.jboss.weld.environment.servlet.logging.UndertowLogger;
import org.jboss.weld.environment.undertow.WeldInstanceFactory;

public class WeldServletExtension
implements ServletExtension {
    public static final String INSTALLED = WeldServletExtension.class.getName() + ".installed";
    public static final String INSTALLED_SERVLET = "servlet-only";
    public static final String INSTALLED_FULL = "full";

    public void handleDeployment(DeploymentInfo deploymentInfo, ServletContext servletContext) {
        for (ServletInfo servlet : deploymentInfo.getServlets().values()) {
            UndertowLogger.LOG.installingCdiSupport(servlet.getServletClass());
            servlet.setInstanceFactory(WeldInstanceFactory.of(servlet.getInstanceFactory(), servletContext, servlet.getServletClass()));
        }
        try {
            for (FilterInfo filter : deploymentInfo.getFilters().values()) {
                UndertowLogger.LOG.installingCdiSupport(filter.getFilterClass());
                filter.setInstanceFactory(WeldInstanceFactory.of(filter.getInstanceFactory(), servletContext, filter.getFilterClass()));
            }
            for (ListenerInfo listener : deploymentInfo.getListeners()) {
                UndertowLogger.LOG.installingCdiSupport(listener.getListenerClass());
                InstanceFactory instanceFactory = listener.getInstanceFactory();
                if (instanceFactory instanceof ImmediateInstanceFactory) continue;
                listener.setInstanceFactory(WeldInstanceFactory.of(instanceFactory, servletContext, listener.getListenerClass()));
            }
            servletContext.setAttribute(INSTALLED, (Object)INSTALLED_FULL);
        }
        catch (NoSuchMethodError e) {
            servletContext.setAttribute(INSTALLED, (Object)INSTALLED_SERVLET);
            return;
        }
    }
}

