/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet.logging;

import java.io.Serializable;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.weld.environment.logging.WeldEnvironmentLogger;
import org.jboss.weld.environment.servlet.logging.WeldServletLogger;

public class WeldServletLogger_$logger
extends DelegatingBasicLogger
implements WeldServletLogger,
WeldEnvironmentLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = WeldServletLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public WeldServletLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void resourceInjectionNotAvailable() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.resourceInjectionNotAvailable$str(), new Object[0]);
    }

    protected String resourceInjectionNotAvailable$str() {
        return "WELD-ENV-001000: @Resource injection not available in simple beans";
    }

    @Override
    public final void noSupportedServletContainerDetected() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.noSupportedServletContainerDetected$str(), new Object[0]);
    }

    protected String noSupportedServletContainerDetected$str() {
        return "WELD-ENV-001001: No supported servlet container detected, CDI injection will NOT be available in Servlets, Filters or Listeners";
    }

    @Override
    public final void containerDetectionSkipped(Object param1) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.containerDetectionSkipped$str(), param1);
    }

    protected String containerDetectionSkipped$str() {
        return "WELD-ENV-001002: Container detection skipped - custom container class loaded: {0}.";
    }

    @Override
    public final void unableToInstantiateCustomContainerClass(Object param1) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.unableToInstantiateCustomContainerClass$str(), param1);
    }

    protected String unableToInstantiateCustomContainerClass$str() {
        return "WELD-ENV-001003: Unable to instantiate custom container class: {0}.";
    }

    @Override
    public final void foundBothConfiguration(Object param1) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.foundBothConfiguration$str(), param1);
    }

    protected String foundBothConfiguration$str() {
        return "WELD-ENV-001004: Found both WEB-INF/beans.xml and WEB-INF/classes/META-INF/beans.xml. It is not portable to use both locations at the same time. Weld is going to use: {0}";
    }

    @Override
    public final void enhancedListenerUsedForNotifications() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.enhancedListenerUsedForNotifications$str(), new Object[0]);
    }

    protected String enhancedListenerUsedForNotifications$str() {
        return "WELD-ENV-001006: org.jboss.weld.environment.servlet.EnhancedListener used to initialize Weld";
    }

    @Override
    public final void initializeWeldUsingServletContextListener() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.initializeWeldUsingServletContextListener$str(), new Object[0]);
    }

    protected String initializeWeldUsingServletContextListener$str() {
        return "WELD-ENV-001007: Initialize Weld using ServletContextListener";
    }

    @Override
    public final void initializeWeldUsingServletContainerInitializer() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.initializeWeldUsingServletContainerInitializer$str(), new Object[0]);
    }

    protected String initializeWeldUsingServletContainerInitializer$str() {
        return "WELD-ENV-001008: Initialize Weld using ServletContainerInitializer";
    }

    @Override
    public final void listenerUserForServletRequestAndHttpSessionNotifications() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.listenerUserForServletRequestAndHttpSessionNotifications$str(), new Object[0]);
    }

    protected String listenerUserForServletRequestAndHttpSessionNotifications$str() {
        return "WELD-ENV-001009: org.jboss.weld.environment.servlet.Listener used for ServletRequest and HttpSession notifications";
    }

    @Override
    public final void problemWhenInterating(Object param1, Throwable cause) {
        this.log.logv(FQCN, Logger.Level.INFO, cause, this.problemWhenInterating$str(), param1);
    }

    protected String problemWhenInterating$str() {
        return "WELD-ENV-001010: Problem when iterating through {0}";
    }

    @Override
    public final void couldNotReadContext(Object param1) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.couldNotReadContext$str(), param1);
    }

    protected String couldNotReadContext$str() {
        return "WELD-ENV-001011: Could not read context {0}: Trying to create it!";
    }

    @Override
    public final void beanManagerReferenceBoundTo(Object param1) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.beanManagerReferenceBoundTo$str(), param1);
    }

    protected String beanManagerReferenceBoundTo$str() {
        return "WELD-ENV-001012: BeanManager reference bound to {0}.";
    }

    @Override
    public final void successfullyUnboundBeanManagerReference() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.successfullyUnboundBeanManagerReference$str(), new Object[0]);
    }

    protected String successfullyUnboundBeanManagerReference$str() {
        return "WELD-ENV-001013: Successfully unbound BeanManager reference.";
    }

    @Override
    public final void failedToUnbindBeanManagerReference() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.failedToUnbindBeanManagerReference$str(), new Object[0]);
    }

    protected String failedToUnbindBeanManagerReference$str() {
        return "WELD-ENV-001014: Failed to unbind BeanManager reference!";
    }

    @Override
    public final void couldntCreateContext(Object param1) {
        this.log.logv(FQCN, Logger.Level.ERROR, null, this.couldntCreateContext$str(), param1);
    }

    protected String couldntCreateContext$str() {
        return "WELD-ENV-001015: Could not create context: {0}.";
    }

    protected String errorLoadingResources$str() {
        return "WELD-ENV-001016: Error loading resources from servlet context.";
    }

    @Override
    public final IllegalStateException errorLoadingResources(Throwable cause) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.errorLoadingResources$str(), new Object[0]), cause);
        WeldServletLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String exceptionFetchingBeanManager$str() {
        return "WELD-ENV-001017: Exception fetching BeanManager instance!";
    }

    @Override
    public final IllegalStateException exceptionFetchingBeanManager(Throwable cause) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.exceptionFetchingBeanManager$str(), new Object[0]), cause);
        WeldServletLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notInAServletOrPortlet$str() {
        return "WELD-ENV-001018: Not in a servlet or portlet environment!";
    }

    @Override
    public final IllegalStateException notInAServletOrPortlet() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.notInAServletOrPortlet$str(), new Object[0]));
        WeldServletLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorCreatingJNDIContext$str() {
        return "WELD-ENV-001019: Error creating JNDI context";
    }

    @Override
    public final IllegalStateException errorCreatingJNDIContext(Throwable cause) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.errorCreatingJNDIContext$str(), new Object[0]), cause);
        WeldServletLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noServiceLoaderClassAvailable$str() {
        return "WELD-ENV-001022: No ServiceLoader class available!";
    }

    @Override
    public final IllegalStateException noServiceLoaderClassAvailable() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noServiceLoaderClassAvailable$str(), new Object[0]));
        WeldServletLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noLoadMethodAvailableOnServiceLoader$str() {
        return "WELD-ENV-001023: No load method available on ServiceLoader - {0}.";
    }

    @Override
    public final IllegalStateException noLoadMethodAvailableOnServiceLoader(Object param1, Throwable cause) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.noLoadMethodAvailableOnServiceLoader$str(), param1), cause);
        WeldServletLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private String _formatMessage(String format, Object ... args) {
        MessageFormat formatter = new MessageFormat(format, this.getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new FieldPosition(0)).toString();
    }

    protected String couldNotBindBeanManagerReferenceToJNDI$str() {
        return "WELD-ENV-001024: Could not bind BeanManager reference to JNDI: {0}\nIf the naming context is read-only, you may need to use a configuration to bind the BeanManager instead, such as Tomcat's context.xml or Jetty's jetty-web.xml.";
    }

    @Override
    public final RuntimeException couldNotBindBeanManagerReferenceToJNDI(Object param1) {
        RuntimeException result = new RuntimeException(this._formatMessage(this.couldNotBindBeanManagerReferenceToJNDI$str(), param1));
        WeldServletLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotCreateInitialContext$str() {
        return "WELD-ENV-001025: Could not create InitialContext to bind BeanManager reference in JNDI: {0}.";
    }

    @Override
    public final RuntimeException couldNotCreateInitialContext(Object param1) {
        RuntimeException result = new RuntimeException(this._formatMessage(this.couldNotCreateInitialContext$str(), param1));
        WeldServletLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorLoadingWeldELContextListener$str() {
        return "WELD-ENV-001028: Error loading Weld ELContext Listener, check that Weld is on the classpath.";
    }

    @Override
    public final IllegalStateException errorLoadingWeldELContextListener(Throwable cause) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.errorLoadingWeldELContextListener$str(), new Object[0]), cause);
        WeldServletLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void noServletLifecycleToDestroy() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.noServletLifecycleToDestroy$str(), new Object[0]);
    }

    protected String noServletLifecycleToDestroy$str() {
        return "WELD-ENV-001029: org.jboss.weld.environment.servlet.Listener is in an inconsistent state - Weld Servlet cannot be shut down properly";
    }

    @Override
    public final void cannotHandleLibrary(Object path, Throwable cause) {
        this.log.logv(FQCN, Logger.Level.ERROR, cause, this.cannotHandleLibrary$str(), path);
    }

    protected String cannotHandleLibrary$str() {
        return "WELD-ENV-001030: Error handling library: {0}.";
    }

    public final void catchingDebug(Throwable arg0) {
        this.log.logf(FQCN, Logger.Level.DEBUG, arg0, this.catchingDebug$str(), new Object[0]);
    }

    protected String catchingDebug$str() {
        return "Catching";
    }

    public final void catchingTrace(Throwable arg0) {
        this.log.logf(FQCN, Logger.Level.TRACE, arg0, this.catchingTrace$str(), new Object[0]);
    }

    protected String catchingTrace$str() {
        return "Catching";
    }
}

