/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet.logging;

import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.weld.environment.logging.WeldEnvironmentLogger;
import org.jboss.weld.environment.servlet.logging.Category;

@MessageLogger(projectCode="WELD-ENV-")
public interface JettyLogger
extends WeldEnvironmentLogger {
    public static final JettyLogger LOG = (JettyLogger)Logger.getMessageLogger(JettyLogger.class, (String)Category.JETTY.getName());

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1200, value="Jetty 7.2+ detected, CDI injection will be available in Servlets and Filters. Injection into Listeners should work on Jetty 9.1.1 and newer.")
    public void jettyDetectedListenersInjectionIsSupported();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1201, value="Jetty 7.2+ detected, CDI injection will be available in Servlets and Filters. Injection into Listeners is not supported.")
    public void jettyDetectedListenersInjectionIsNotSupported();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1202, value="Unable to create JettyWeldInjector. CDI injection will not be available in Servlets, Filters or Listeners.")
    public void unableToCreateJettyWeldInjector(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1203, value="GWTHostedMode detected, JSR-299 injection will be available in Servlets and Filters. Injection into Listeners is not supported.")
    public void gwtHostedModeDetected();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1204, value="Can't find Injector in the servlet context so injection is not available for {0}.", format=Message.Format.MESSAGE_FORMAT)
    public void cantFindInjector(Object var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1205, value="Missing jetty-env.xml, no BeanManager present in JNDI.")
    public void missingJettyEnv();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1206, value="Cannot find matching WebApplicationContext, no default CDI support: use jetty-web.xml")
    public void cantFindWebApplicationContext();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1207, value="Can't find Injector in the servlet context so injection is not available for {0}.", format=Message.Format.MESSAGE_FORMAT)
    public void cantFindInjectior(Object var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1208, value="Missing jetty-env.xml, no BeanManager present in JNDI.")
    public void missingJettyEnvXml();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1209, value="Cannot find matching WebApplicationContext, no default CDI support: use jetty-web.xml")
    public void cantFindMatchingWebApplicationContext();

    @Message(id=1210, value="No such Jetty injector found in servlet context attributes.")
    public IllegalStateException noSuchJettyInjectorFound();
}

