/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.undertow;

import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.InstanceHandle;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Unmanaged;
import javax.servlet.ServletContext;
import org.jboss.weld.bean.builtin.BeanManagerProxy;
import org.jboss.weld.environment.servlet.WeldServletLifecycle;
import org.jboss.weld.util.reflection.Reflections;

class WeldInstanceFactory<T>
implements InstanceFactory<T> {
    private final InstanceFactory<T> delegate;
    private final ServletContext context;
    private final Class<T> clazz;

    static <T> WeldInstanceFactory<T> of(InstanceFactory<T> delegate, ServletContext context, Class<?> clazz) {
        return new WeldInstanceFactory<T>(delegate, context, (Class)Reflections.cast(clazz));
    }

    private WeldInstanceFactory(InstanceFactory<T> delegate, ServletContext context, Class<T> clazz) {
        this.delegate = delegate;
        this.context = context;
        this.clazz = clazz;
    }

    public InstanceHandle<T> createInstance() throws InstantiationException {
        Object manager = this.context.getAttribute(WeldServletLifecycle.BEAN_MANAGER_ATTRIBUTE_NAME);
        if (manager instanceof BeanManager) {
            Unmanaged.UnmanagedInstance instance = new Unmanaged((BeanManager)BeanManagerProxy.unwrap((BeanManager)((BeanManager)manager)), this.clazz).newInstance();
            instance.produce().inject().postConstruct();
            return new WeldInstanceHandle(instance);
        }
        return this.delegate.createInstance();
    }

    public String toString() {
        return "WeldInstanceFactory [clazz=" + this.clazz + "]";
    }

    private static class WeldInstanceHandle<T>
    implements InstanceHandle<T> {
        private final Unmanaged.UnmanagedInstance<T> instance;

        WeldInstanceHandle(Unmanaged.UnmanagedInstance<T> instance) {
            this.instance = instance;
        }

        public T getInstance() {
            return (T)this.instance.get();
        }

        public void release() {
            this.instance.preDestroy();
            this.instance.dispose();
        }

        public String toString() {
            return "WeldInstanceHandle [instance=" + this.instance + "]";
        }
    }
}

