/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.faces.staging;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.test.faces.staging.AbstractServerResource;
import org.jboss.test.faces.staging.ServerLogger;

public class StringContentServerResource
extends AbstractServerResource {
    private final byte[] contentBytes;
    private static final Logger log = ServerLogger.RESOURCE.getLogger();

    public StringContentServerResource(String content) {
        this.contentBytes = content.getBytes();
    }

    @Override
    public InputStream getAsStream() throws IOException {
        return new ByteArrayInputStream(this.contentBytes);
    }

    @Override
    public URL getURL() {
        try {
            return new URL("urn", null, 0, "", new URLStreamHandler(){

                @Override
                protected URLConnection openConnection(URL u) throws IOException {
                    return new URLConnection(u){

                        @Override
                        public void connect() throws IOException {
                        }

                        @Override
                        public Object getContent() throws IOException {
                            return StringContentServerResource.this.contentBytes;
                        }

                        @Override
                        public InputStream getInputStream() throws IOException {
                            return StringContentServerResource.this.getAsStream();
                        }
                    };
                }
            });
        }
        catch (MalformedURLException e) {
            log.log(Level.WARNING, "Malformed StringContentResourceURL", e);
            return null;
        }
    }
}

