/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.faces.staging;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import org.jboss.test.faces.staging.ServerLogger;
import org.jboss.test.faces.staging.ServerResource;

abstract class StagingServletContext
implements ServletContext {
    private static final Logger log = ServerLogger.SERVER.getLogger();
    public static final String CONTEXT_PATH = "";
    private static final String APPLICATION_NAME = "stub";
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private final Map<String, String> initParameters = new HashMap<String, String>();

    StagingServletContext() {
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public ServletContext getContext(String uripath) {
        return null;
    }

    public String getContextPath() {
        return CONTEXT_PATH;
    }

    public void addInitParameters(Map<String, String> parameters) {
        this.initParameters.putAll(parameters);
    }

    public String getInitParameter(String name) {
        return this.initParameters.get(name);
    }

    public boolean setInitParameter(String name, String value) {
        return null != this.initParameters.put(name, value);
    }

    public Enumeration getInitParameterNames() {
        return Collections.enumeration(this.initParameters.keySet());
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 5;
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        log.info("unimplemented response method getNamedDispatcher");
        return null;
    }

    public String getRealPath(String path) {
        return null;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        log.info("unimplemented response method getRequestDispatcher");
        return null;
    }

    public URL getResource(String path) throws MalformedURLException {
        URL url = null;
        ServerResource resource = this.getServerResource(path);
        if (null != resource) {
            url = resource.getURL();
        }
        return url;
    }

    protected abstract ServerResource getServerResource(String var1);

    public InputStream getResourceAsStream(String path) {
        ServerResource resource = this.getServerResource(path);
        if (null != resource) {
            try {
                return resource.getAsStream();
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    public Set getResourcePaths(String path) {
        Set<String> paths;
        HashSet<String> result = null;
        ServerResource resource = this.getServerResource(path);
        if (null == resource && !path.endsWith("/")) {
            path = path + "/";
            resource = this.getServerResource(path);
        }
        if (null != resource && null != (paths = resource.getPaths()) && paths.size() > 0) {
            result = new HashSet<String>(paths.size());
            for (String resourcePath : paths) {
                result.add(path + resourcePath);
            }
        }
        return result;
    }

    public String getServerInfo() {
        return "Stub test server";
    }

    public Servlet getServlet(String name) throws ServletException {
        log.info("unimplemented response method getServlet");
        return null;
    }

    public String getServletContextName() {
        return APPLICATION_NAME;
    }

    public Enumeration getServletNames() {
        log.info("unimplemented response method getServletNames");
        return Collections.enumeration(Collections.EMPTY_LIST);
    }

    public Enumeration getServlets() {
        log.info("unimplemented response method getServlets");
        return Collections.enumeration(Collections.EMPTY_LIST);
    }

    public void log(String msg) {
        log.finest(msg);
    }

    public void log(Exception exception, String msg) {
        log.log(Level.FINEST, msg, exception);
    }

    public void log(String message, Throwable throwable) {
        log.log(Level.FINEST, message, throwable);
    }

    public void removeAttribute(String name) {
        Object removed = this.attributes.remove(name);
        if (null != removed) {
            this.valueUnbound(new ServletContextAttributeEvent((ServletContext)this, name, removed));
        }
    }

    public void setAttribute(String name, Object object) {
        if (null == object) {
            this.removeAttribute(name);
        } else {
            Object oldValue = this.attributes.put(name, object);
            ServletContextAttributeEvent event = new ServletContextAttributeEvent((ServletContext)this, name, object);
            if (null != oldValue) {
                this.valueReplaced(event);
            } else {
                this.valueBound(event);
            }
        }
    }

    protected abstract void valueBound(ServletContextAttributeEvent var1);

    protected abstract void valueReplaced(ServletContextAttributeEvent var1);

    protected abstract void valueUnbound(ServletContextAttributeEvent var1);

    public FilterRegistration.Dynamic addFilter(String arg0, Class<? extends Filter> arg1) {
        return null;
    }

    public FilterRegistration.Dynamic addFilter(String arg0, Filter arg1) {
        return null;
    }

    public FilterRegistration.Dynamic addFilter(String arg0, String arg1) {
        return null;
    }

    public void addListener(Class<? extends EventListener> arg0) {
    }

    public void addListener(String arg0) {
    }

    public <T extends EventListener> void addListener(T arg0) {
    }

    public ServletRegistration.Dynamic addServlet(String arg0, Class<? extends Servlet> arg1) {
        return null;
    }

    public ServletRegistration.Dynamic addServlet(String arg0, Servlet arg1) {
        return null;
    }

    public ServletRegistration.Dynamic addServlet(String arg0, String arg1) {
        return null;
    }

    public <T extends Filter> T createFilter(Class<T> arg0) throws ServletException {
        return null;
    }

    public <T extends EventListener> T createListener(Class<T> arg0) throws ServletException {
        return null;
    }

    public <T extends Servlet> T createServlet(Class<T> arg0) throws ServletException {
        return null;
    }

    public void declareRoles(String ... arg0) {
    }

    public ClassLoader getClassLoader() {
        return null;
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return null;
    }

    public int getEffectiveMajorVersion() {
        return 3;
    }

    public int getEffectiveMinorVersion() {
        return 0;
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return null;
    }

    public FilterRegistration getFilterRegistration(String arg0) {
        return null;
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        return null;
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        return null;
    }

    public String getMimeType(String arg0) {
        return null;
    }

    public ServletRegistration getServletRegistration(String arg0) {
        return null;
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        return null;
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return null;
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> arg0) {
    }
}

