/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.faces.staging;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.spi.NamingManager;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import javax.servlet.jsp.JspFactory;
import org.jboss.test.faces.ApplicationServer;
import org.jboss.test.faces.FilterHolder;
import org.jboss.test.faces.ServletHolder;
import org.jboss.test.faces.TestException;
import org.jboss.test.faces.staging.ClasspathServerResource;
import org.jboss.test.faces.staging.EventInvoker;
import org.jboss.test.faces.staging.FilterContainer;
import org.jboss.test.faces.staging.InvocationErrorEvent;
import org.jboss.test.faces.staging.InvocationEvent;
import org.jboss.test.faces.staging.InvocationListener;
import org.jboss.test.faces.staging.RequestChain;
import org.jboss.test.faces.staging.ServerLogger;
import org.jboss.test.faces.staging.ServerResource;
import org.jboss.test.faces.staging.ServerResourceDirectory;
import org.jboss.test.faces.staging.ServerResourceDirectoryImpl;
import org.jboss.test.faces.staging.ServerResourcePath;
import org.jboss.test.faces.staging.ServletContainer;
import org.jboss.test.faces.staging.StaggingJspFactory;
import org.jboss.test.faces.staging.StagingConnection;
import org.jboss.test.faces.staging.StagingHttpSession;
import org.jboss.test.faces.staging.StagingInitialContextFactoryBuilder;
import org.jboss.test.faces.staging.StagingServletContext;
import org.jboss.test.faces.staging.StaticServlet;
import org.jboss.test.faces.staging.StringContentServerResource;
import org.jboss.test.faces.staging.UrlServerResource;

public class StagingServer
extends ApplicationServer {
    private static final Class<ServletRequestListener> REQUEST_LISTENER_CLASS = ServletRequestListener.class;
    private static final Class<ServletRequestAttributeListener> REQUEST_ATTRIBUTE_LISTENER_CLASS = ServletRequestAttributeListener.class;
    private static final Class<ServletContextListener> CONTEXT_LISTENER_CLASS = ServletContextListener.class;
    private static final Class<HttpSessionListener> SESSION_LISTENER_CLASS = HttpSessionListener.class;
    private static final Class<HttpSessionAttributeListener> SESSION_ATTRIBUTE_LISTENER_CLASS = HttpSessionAttributeListener.class;
    private static final Logger log = ServerLogger.SERVER.getLogger();
    private final List<RequestChain> servlets = new ArrayList<RequestChain>();
    private RequestChain defaultServlet = new ServletContainer(null, (Servlet)new StaticServlet());
    private final List<EventListener> contextListeners = new ArrayList<EventListener>();
    private final Map<String, String> initParameters = new HashMap<String, String>();
    private final ServerResourceDirectory serverRoot = new ServerResourceDirectoryImpl();
    private final Map<String, String> mimeTypes = new HashMap<String, String>();
    private InvocationListener invocationListener;
    private final StagingServletContext context = new LocalContext();
    private ServletContext contextProxy;
    private HttpSession currentSession = null;
    private ThreadLocal<HttpSession> sessions = new ThreadLocal();
    private List<ServerHttpSession> sessionInstances = new ArrayList<ServerHttpSession>();
    private boolean sessionPerThread = false;
    private int port = 0;
    private boolean initialised = false;

    private <T extends EventListener> int fireEvent(Class<T> listenerClass, EventInvoker<T> invoker) {
        int errorsCount = 0;
        for (EventListener listener : this.contextListeners) {
            if (!listenerClass.isInstance(listener)) continue;
            try {
                invoker.invoke(listener);
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, "Exception in listener", e);
                ++errorsCount;
            }
        }
        return errorsCount;
    }

    @Override
    protected void addDirectory(String directoryPath) {
        this.serverRoot.addDirectory(new ServerResourcePath(directoryPath));
    }

    public void addServlet(RequestChain servlet) {
        this.servlets.add(servlet);
    }

    public void replaceServlet(RequestChain oldHandler, RequestChain newHandler) {
        this.servlets.remove(oldHandler);
        this.servlets.add(newHandler);
    }

    public void addServlet(String mapping, Servlet servlet) {
        this.servlets.add(new ServletContainer(mapping, servlet));
    }

    public RequestChain getServlet(String path) {
        RequestChain result = null;
        for (RequestChain servlet : this.servlets) {
            if (!servlet.isApplicable(path)) continue;
            result = servlet;
            break;
        }
        if (null == result) {
            try {
                URL resource = this.context.getResource(path);
                if (null != resource) {
                    result = this.defaultServlet;
                }
            }
            catch (MalformedURLException e) {
                log.warning("Mailformed request URL " + e.getMessage());
            }
        }
        return result;
    }

    @Override
    public void addInitParameter(String name, String value) {
        this.initParameters.put(name, value);
    }

    @Override
    public void addMimeType(String extension, String mimeType) {
        this.mimeTypes.put(extension, mimeType);
    }

    @Override
    public void addContent(String path, String content) {
        ServerResourcePath resourcePath = new ServerResourcePath(path);
        this.serverRoot.addResource(resourcePath, new StringContentServerResource(content));
    }

    @Override
    public void addResource(String path, String resource) {
        ServerResourcePath resourcePath = new ServerResourcePath(path);
        this.serverRoot.addResource(resourcePath, new ClasspathServerResource(resource));
    }

    @Override
    public void addResource(String path, URL resource) {
        this.serverRoot.addResource(new ServerResourcePath(path), new UrlServerResource(resource));
    }

    @Override
    public void addWebListener(EventListener listener) {
        this.contextListeners.add(listener);
    }

    public InvocationListener getInvocationListener() {
        return this.invocationListener;
    }

    public void setInvocationListener(InvocationListener invocationListener) {
        this.invocationListener = invocationListener;
    }

    InvocationHandler getInvocationHandler(final Object target) {
        return new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                InvocationListener listener = StagingServer.this.getInvocationListener();
                try {
                    Object result = method.invoke(target, args);
                    if (null != listener) {
                        listener.afterInvoke(new InvocationEvent(target, method, args, result));
                    }
                    return result;
                }
                catch (Throwable e) {
                    if (null != listener) {
                        listener.processException(new InvocationErrorEvent(target, method, args, e));
                    }
                    throw e;
                }
            }
        };
    }

    @Override
    public boolean isSessionPerThread() {
        return this.sessionPerThread;
    }

    @Override
    public void setSessionPerThread(boolean sessionPerThread) {
        this.sessionPerThread = sessionPerThread;
    }

    HttpSession getCurrentSession() {
        if (this.isSessionPerThread()) {
            return this.sessions.get();
        }
        return this.currentSession;
    }

    void setCurrentSession(HttpSession session) {
        if (this.isSessionPerThread()) {
            this.sessions.set(session);
        } else {
            this.currentSession = session;
        }
    }

    @Override
    public HttpSession getSession() {
        return this.getSession(true);
    }

    @Override
    public synchronized HttpSession getSession(boolean create) {
        if (!this.initialised) {
            throw new TestException("Staging server have not been initialised");
        }
        HttpSession httpSession = this.getCurrentSession();
        if (null == httpSession && create) {
            ServerHttpSession sessionImpl = new ServerHttpSession();
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (null == loader) {
                loader = this.getClass().getClassLoader();
            }
            httpSession = (HttpSession)Proxy.newProxyInstance(loader, new Class[]{HttpSession.class}, this.getInvocationHandler(sessionImpl));
            this.setCurrentSession(httpSession);
            final HttpSessionEvent event = new HttpSessionEvent(httpSession);
            this.fireEvent(SESSION_LISTENER_CLASS, new EventInvoker<HttpSessionListener>(){

                @Override
                public void invoke(HttpSessionListener listener) {
                    listener.sessionCreated(event);
                }
            });
            this.sessionInstances.add(sessionImpl);
        }
        return httpSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readDefaultMimeTypes() {
        InputStream is = null;
        try {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream("org/jboss/test/faces/staging/mime.properties");
            Properties props = new Properties();
            props.load(is);
            for (Object key : props.keySet()) {
                this.mimeTypes.put("." + key, props.getProperty((String)key));
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.log(Level.WARNING, e.getMessage(), e);
                }
            }
        }
    }

    @Override
    public void init() {
        log.info("Init staging server");
        this.readDefaultMimeTypes();
        JspFactory.setDefaultFactory((JspFactory)new StaggingJspFactory(this.context));
        this.context.addInitParameters(this.initParameters);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (null == loader) {
            loader = this.getClass().getClassLoader();
        }
        this.contextProxy = (ServletContext)Proxy.newProxyInstance(loader, new Class[]{ServletContext.class}, this.getInvocationHandler(this.context));
        final ServletContextEvent event = new ServletContextEvent((ServletContext)this.context);
        if (this.fireEvent(CONTEXT_LISTENER_CLASS, new EventInvoker<ServletContextListener>(){

            @Override
            public void invoke(ServletContextListener listener) {
                listener.contextInitialized(event);
            }
        }) > 0) {
            throw new TestException("Server not started due to listener error ");
        }
        try {
            for (RequestChain servlet : this.servlets) {
                servlet.init(this.context);
            }
            this.defaultServlet.init(this.context);
        }
        catch (ServletException e) {
            throw new TestException("Servlet initialisation error ", e);
        }
        try {
            NamingManager.setInitialContextFactoryBuilder(new StagingInitialContextFactoryBuilder());
        }
        catch (NamingException e) {
            log.warning("Error set initial context factory builder.");
        }
        catch (IllegalStateException e) {
            log.warning("Initial context factory builder already set.");
        }
        this.initialised = true;
    }

    @Override
    public void destroy() {
        if (!this.initialised) {
            throw new TestException("Staging server have not been initialised");
        }
        this.initialised = false;
        Iterator<ServerHttpSession> sessionIterator = this.sessionInstances.iterator();
        while (sessionIterator.hasNext()) {
            ServerHttpSession session = sessionIterator.next();
            final HttpSessionEvent event = new HttpSessionEvent((HttpSession)session);
            this.fireEvent(SESSION_LISTENER_CLASS, new EventInvoker<HttpSessionListener>(){

                @Override
                public void invoke(HttpSessionListener listener) {
                    listener.sessionDestroyed(event);
                }
            });
            session.invalidate();
            sessionIterator.remove();
        }
        this.setCurrentSession(null);
        final ServletContextEvent event = new ServletContextEvent((ServletContext)this.context);
        this.fireEvent(CONTEXT_LISTENER_CLASS, new EventInvoker<ServletContextListener>(){

            @Override
            public void invoke(ServletContextListener listener) {
                listener.contextDestroyed(event);
            }
        });
        for (RequestChain servlet : this.servlets) {
            servlet.destroy();
        }
        this.defaultServlet.destroy();
        JspFactory.setDefaultFactory(null);
        this.contextProxy = null;
        log.info("Staging server have been destroyed");
    }

    @Override
    public StagingConnection getConnection(URL url) {
        if (!this.initialised) {
            throw new TestException("Staging server have not been initialised");
        }
        return new StagingConnection(this, url);
    }

    @Override
    public ServletContext getContext() {
        if (!this.initialised) {
            throw new TestException("Staging server have not been initialised");
        }
        return this.contextProxy;
    }

    void requestStarted(ServletRequest request) {
        final ServletRequestEvent event = new ServletRequestEvent((ServletContext)this.context, request);
        this.fireEvent(REQUEST_LISTENER_CLASS, new EventInvoker<ServletRequestListener>(){

            @Override
            public void invoke(ServletRequestListener listener) {
                listener.requestInitialized(event);
            }
        });
    }

    void requestFinished(ServletRequest request) {
        final ServletRequestEvent event = new ServletRequestEvent((ServletContext)this.context, request);
        this.fireEvent(REQUEST_LISTENER_CLASS, new EventInvoker<ServletRequestListener>(){

            @Override
            public void invoke(ServletRequestListener listener) {
                listener.requestDestroyed(event);
            }
        });
    }

    void requestAttributeAdded(ServletRequest request, String name, Object o) {
        final ServletRequestAttributeEvent event = new ServletRequestAttributeEvent((ServletContext)this.context, request, name, o);
        this.fireEvent(REQUEST_ATTRIBUTE_LISTENER_CLASS, new EventInvoker<ServletRequestAttributeListener>(){

            @Override
            public void invoke(ServletRequestAttributeListener listener) {
                listener.attributeAdded(event);
            }
        });
    }

    void requestAttributeRemoved(ServletRequest request, String name, Object removed) {
        final ServletRequestAttributeEvent event = new ServletRequestAttributeEvent((ServletContext)this.context, request, name, removed);
        this.fireEvent(REQUEST_ATTRIBUTE_LISTENER_CLASS, new EventInvoker<ServletRequestAttributeListener>(){

            @Override
            public void invoke(ServletRequestAttributeListener listener) {
                listener.attributeRemoved(event);
            }
        });
    }

    void requestAttributeReplaced(ServletRequest request, String name, Object value) {
        final ServletRequestAttributeEvent event = new ServletRequestAttributeEvent((ServletContext)this.context, request, name, value);
        this.fireEvent(REQUEST_ATTRIBUTE_LISTENER_CLASS, new EventInvoker<ServletRequestAttributeListener>(){

            @Override
            public void invoke(ServletRequestAttributeListener listener) {
                listener.attributeReplaced(event);
            }
        });
    }

    @Override
    public void addFilter(FilterHolder filterHolder) {
        Map initParameters = filterHolder.getInitParameters();
        String mapping = filterHolder.getMapping();
        String name = filterHolder.getName();
        Filter filter = filterHolder.getFilter();
        RequestChain oldHandler = this.getServlet(mapping);
        FilterContainer newHandler = new FilterContainer(filter, oldHandler);
        newHandler.setName(name);
        if (initParameters != null) {
            for (Map.Entry initEntry : initParameters.entrySet()) {
                newHandler.addInitParameter((String)initEntry.getKey(), (String)initEntry.getValue());
            }
        }
        this.replaceServlet(oldHandler, newHandler);
    }

    @Override
    public void addServlet(ServletHolder servletHolder) {
        Map initParameters = servletHolder.getInitParameters();
        String mapping = servletHolder.getMapping();
        String name = servletHolder.getName();
        Servlet servlet = servletHolder.getServlet();
        ServletContainer servletContainer = new ServletContainer(mapping, servlet);
        servletContainer.setName(name);
        if (initParameters != null) {
            for (Map.Entry initEntry : initParameters.entrySet()) {
                servletContainer.addInitParameter((String)initEntry.getKey(), (String)initEntry.getValue());
            }
        }
        this.addServlet(servletContainer);
    }

    @Override
    public int getPort() {
        return this.port;
    }

    private class ServerHttpSession
    extends StagingHttpSession {
        private ServerHttpSession() {
        }

        public ServletContext getServletContext() {
            return StagingServer.this.context;
        }

        @Override
        protected void valueBound(final HttpSessionBindingEvent sessionBindingEvent) {
            StagingServer.this.fireEvent(SESSION_ATTRIBUTE_LISTENER_CLASS, new EventInvoker<HttpSessionAttributeListener>(){

                @Override
                public void invoke(HttpSessionAttributeListener listener) {
                    listener.attributeAdded(sessionBindingEvent);
                }
            });
        }

        @Override
        protected void valueUnbound(final HttpSessionBindingEvent sessionBindingEvent) {
            StagingServer.this.fireEvent(SESSION_ATTRIBUTE_LISTENER_CLASS, new EventInvoker<HttpSessionAttributeListener>(){

                @Override
                public void invoke(HttpSessionAttributeListener listener) {
                    listener.attributeRemoved(sessionBindingEvent);
                }
            });
        }

        @Override
        protected void valueReplaced(final HttpSessionBindingEvent sessionBindingEvent) {
            StagingServer.this.fireEvent(SESSION_ATTRIBUTE_LISTENER_CLASS, new EventInvoker<HttpSessionAttributeListener>(){

                @Override
                public void invoke(HttpSessionAttributeListener listener) {
                    listener.attributeReplaced(sessionBindingEvent);
                }
            });
        }

        @Override
        public void invalidate() {
            super.invalidate();
            StagingServer.this.setCurrentSession(null);
        }
    }

    private class LocalContext
    extends StagingServletContext {
        private LocalContext() {
        }

        @Override
        public String getMimeType(String file) {
            int indexOfDot = file.lastIndexOf(46);
            if (indexOfDot >= 0) {
                file = file.substring(indexOfDot);
            }
            return (String)StagingServer.this.mimeTypes.get(file);
        }

        @Override
        protected void valueBound(ServletContextAttributeEvent event) {
            for (EventListener listener : StagingServer.this.contextListeners) {
                if (!(listener instanceof ServletContextAttributeListener)) continue;
                ServletContextAttributeListener contextListener = (ServletContextAttributeListener)listener;
                contextListener.attributeAdded(event);
            }
        }

        @Override
        protected void valueReplaced(ServletContextAttributeEvent event) {
            for (EventListener listener : StagingServer.this.contextListeners) {
                if (!(listener instanceof ServletContextAttributeListener)) continue;
                ServletContextAttributeListener contextListener = (ServletContextAttributeListener)listener;
                contextListener.attributeReplaced(event);
            }
        }

        @Override
        protected void valueUnbound(ServletContextAttributeEvent event) {
            for (EventListener listener : StagingServer.this.contextListeners) {
                if (!(listener instanceof ServletContextAttributeListener)) continue;
                ServletContextAttributeListener contextListener = (ServletContextAttributeListener)listener;
                contextListener.attributeRemoved(event);
            }
        }

        @Override
        protected ServerResource getServerResource(String path) {
            return StagingServer.this.serverRoot.getResource(new ServerResourcePath(path));
        }
    }
}

