/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.faces.staging;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.jboss.test.faces.staging.ServerLogger;

abstract class StagingHttpResponse
implements HttpServletResponse {
    private static final Logger log = ServerLogger.CONNECTION.getLogger();
    private int status = 200;
    private String redirectLocation = null;
    private String errorMessage = null;
    private int bufferSize = 8196;
    private StringWriter outputWriter;
    private ByteArrayOutputStream outputStream;
    private PrintWriter printWriter;
    private ServletOutputStream servletOutputStream;
    private Locale locale = Locale.US;
    private String contentType = "text";
    private int contentLength = Integer.MIN_VALUE;
    private String encoding = "UTF-8";
    private final Map<String, String[]> headers = new HashMap<String, String[]>();

    StagingHttpResponse() {
    }

    Map<String, String[]> getHeaders() {
        return this.headers;
    }

    public void addDateHeader(String name, long date) {
        this.addHeader(name, new Date(date).toString());
    }

    public void addHeader(String name, String value) {
        String[] values = this.headers.get(name);
        if (null == values) {
            values = new String[1];
        } else {
            String[] newValues = new String[values.length + 1];
            System.arraycopy(values, 0, newValues, 0, values.length);
            values = newValues;
        }
        values[values.length - 1] = value;
        this.headers.put(name, values);
    }

    public void addIntHeader(String name, int value) {
        this.addHeader(name, String.valueOf(value));
    }

    public void addCookie(Cookie cookie) {
        StringBuilder content = new StringBuilder();
        String name = cookie.getName();
        String value = cookie.getValue();
        if (null != name && null != value) {
            content.append(name).append('=').append(value);
            if (null != cookie.getPath()) {
                content.append("; path=").append(cookie.getPath());
            }
            if (null != cookie.getDomain()) {
                content.append("; domain=").append(cookie.getDomain());
            }
        }
        this.addHeader("Set-Cookie", content.toString());
    }

    public boolean containsHeader(String name) {
        return this.headers.containsKey(name);
    }

    public String encodeRedirectURL(String url) {
        return url;
    }

    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public String encodeURL(String url) {
        return url;
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public void sendError(int sc) throws IOException {
        this.status = sc;
    }

    public void sendError(int sc, String msg) throws IOException {
        this.status = sc;
        this.errorMessage = msg;
    }

    public void sendRedirect(String location) throws IOException {
        this.redirectLocation = location;
    }

    public void setDateHeader(String name, long date) {
        this.setHeader(name, new Date(date).toString());
    }

    public void setHeader(String name, String value) {
        this.headers.put(name, new String[]{value});
    }

    public void setIntHeader(String name, int value) {
        this.setHeader(name, String.valueOf(value));
    }

    public void setStatus(int sc) {
        this.status = sc;
    }

    public void setStatus(int sc, String sm) {
        this.status = sc;
    }

    public void flushBuffer() throws IOException {
        log.info("unimplemented response method flushBuffer");
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public String getCharacterEncoding() {
        return this.encoding;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (null != this.outputWriter) {
            throw new IllegalStateException();
        }
        if (this.outputStream == null) {
            this.outputStream = new ByteArrayOutputStream(this.getBufferSize());
            this.servletOutputStream = new ServletOutputStream(){

                public void write(int b) throws IOException {
                    StagingHttpResponse.this.outputStream.write(b);
                }
            };
        }
        return this.servletOutputStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (null != this.outputStream) {
            throw new IllegalStateException();
        }
        if (this.outputWriter == null) {
            this.outputWriter = new StringWriter(this.getBufferSize());
            this.printWriter = new PrintWriter(this.outputWriter);
        }
        return this.printWriter;
    }

    public String getWriterContent() {
        if (null != this.outputWriter) {
            return this.outputWriter.toString();
        }
        return null;
    }

    public byte[] getStreamContent() {
        if (null != this.outputStream) {
            return this.outputStream.toByteArray();
        }
        return null;
    }

    public boolean isCommitted() {
        log.info("unimplemented response method isCommited");
        return false;
    }

    public void reset() {
        if (this.isCommitted()) {
            throw new IllegalStateException();
        }
        this.resetBuffer();
    }

    public void resetBuffer() {
        if (this.isCommitted()) {
            throw new IllegalStateException();
        }
        this.servletOutputStream = null;
        this.outputStream = null;
        this.printWriter = null;
        this.outputWriter = null;
    }

    public void setBufferSize(int size) {
        this.bufferSize = size;
    }

    public void setCharacterEncoding(String charset) {
        this.encoding = charset;
    }

    public void setContentLength(int len) {
        this.contentLength = len;
    }

    public void setContentType(String type) {
        if (null == type) {
            throw new NullPointerException();
        }
        int i = type.indexOf(59);
        if (i >= 0) {
            this.setHeader("Content-Type", type);
            this.contentType = type.substring(0, i).trim();
            i = type.lastIndexOf(61);
            if (i >= 0) {
                this.setCharacterEncoding(type.substring(i + 1).trim());
            }
        } else {
            this.setHeader("Content-Type", type + ";charset=" + this.getCharacterEncoding());
            this.contentType = type;
        }
    }

    public void setLocale(Locale loc) {
        this.locale = loc;
    }

    public int getStatus() {
        return this.status;
    }

    public String getHeader(String arg0) {
        return null;
    }

    public Collection<String> getHeaderNames() {
        return null;
    }

    public Collection<String> getHeaders(String arg0) {
        return null;
    }

    int getContentLength() {
        return this.contentLength;
    }

    String getRedirectLocation() {
        return this.redirectLocation;
    }

    String getErrorMessage() {
        return this.errorMessage;
    }
}

