/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.faces.staging;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jboss.test.faces.TestException;
import org.jboss.test.faces.staging.HttpConnection;
import org.jboss.test.faces.staging.RequestChain;
import org.jboss.test.faces.staging.ServerLogger;
import org.jboss.test.faces.staging.StagingHttpRequest;
import org.jboss.test.faces.staging.StagingHttpResponse;
import org.jboss.test.faces.staging.StagingServer;

public class StagingConnection
extends HttpConnection {
    private static final Logger log = ServerLogger.SERVER.getLogger();
    private final StagingServer server;
    private final URL url;
    private final ConnectionRequest request;
    private final ConnectionResponse response;
    private final RequestChain servlet;
    private static final Cookie[] COOKIE = new Cookie[0];
    private List<Cookie> cookies = new ArrayList<Cookie>();
    private final String pathInfo;
    private final String servletPath;
    private boolean finished = false;
    private boolean started = false;
    private final HttpServletRequest requestProxy;
    private final HttpServletResponse responseProxy;

    StagingConnection(StagingServer localServer, URL url) {
        ClassLoader loader;
        this.server = localServer;
        this.url = url;
        String path = url.getPath();
        this.servlet = localServer.getServlet(path);
        if (null == this.servlet) {
            throw new IllegalArgumentException();
        }
        this.pathInfo = this.servlet.getPathInfo(path);
        this.servletPath = this.servlet.getServletPath(path);
        this.request = new ConnectionRequest();
        this.response = new ConnectionResponse();
        this.request.setAttribute("javax.servlet.include.path_info", this.pathInfo);
        this.request.setAttribute("javax.servlet.include.servlet_path", this.servletPath);
        String queryString = url.getQuery();
        if (null != queryString) {
            this.parseFormParameters(queryString);
        }
        if (null == (loader = Thread.currentThread().getContextClassLoader())) {
            loader = this.getClass().getClassLoader();
        }
        this.requestProxy = (HttpServletRequest)Proxy.newProxyInstance(loader, new Class[]{HttpServletRequest.class}, this.server.getInvocationHandler(this.request));
        this.responseProxy = (HttpServletResponse)Proxy.newProxyInstance(loader, new Class[]{HttpServletResponse.class}, this.server.getInvocationHandler(this.response));
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void execute() {
        if (this.isStarted() || this.isFinished()) {
            throw new TestException("request have already been executed");
        }
        this.start();
        try {
            this.servlet.execute((ServletRequest)this.request, (ServletResponse)this.response);
        }
        catch (ServletException e) {
            throw new TestException("Error execute request ", e);
        }
        catch (IOException e) {
            throw new TestException("IO Error during request execution", e);
        }
        finally {
            this.finish();
        }
    }

    @Override
    public void finish() {
        this.server.requestFinished((ServletRequest)this.request);
        this.finished = true;
    }

    @Override
    public void start() {
        log.fine("start " + (Object)((Object)this.getRequestMethod()) + " request processing for file " + this.url.getFile());
        log.fine("request parameters: " + this.getRequestParameters());
        this.server.requestStarted((ServletRequest)this.request);
        this.started = true;
    }

    public URL getUrl() {
        return this.url;
    }

    @Override
    public String getContentAsString() {
        byte[] streamContent;
        String content = this.response.getWriterContent();
        if (null == content && null != (streamContent = this.response.getStreamContent())) {
            String encoding = this.response.getCharacterEncoding();
            if (null != encoding) {
                try {
                    content = new String(streamContent, encoding);
                }
                catch (UnsupportedEncodingException e) {
                    throw new TestException(e);
                }
            } else {
                content = new String(streamContent);
            }
        }
        return content;
    }

    @Override
    public byte[] getResponseBody() {
        byte[] content = this.response.getStreamContent();
        if (null == content) {
            String writerContent = this.response.getWriterContent();
            if (null != writerContent) {
                try {
                    content = writerContent.getBytes(this.response.getCharacterEncoding());
                }
                catch (UnsupportedEncodingException e) {
                    content = writerContent.getBytes();
                }
            } else {
                content = new byte[]{};
            }
        }
        return content;
    }

    private List<Cookie> getCookies() {
        return this.cookies;
    }

    @Override
    public HttpServletRequest getRequest() {
        return this.requestProxy;
    }

    @Override
    public HttpServletResponse getResponse() {
        return this.responseProxy;
    }

    @Override
    public String getResponseCharacterEncoding() {
        return this.response.getCharacterEncoding();
    }

    @Override
    public String getResponseContentType() {
        return this.response.getContentType();
    }

    @Override
    public int getResponseStatus() {
        return this.response.getStatus();
    }

    @Override
    public String getErrorMessage() {
        return this.response.getErrorMessage();
    }

    @Override
    public Map<String, String[]> getResponseHeaders() {
        return this.response.getHeaders();
    }

    @Override
    public void setRequestCharacterEncoding(String charset) throws UnsupportedEncodingException {
        this.request.setCharacterEncoding(charset);
    }

    @Override
    public void setRequestBody(String body) {
        this.request.setRequestBody(body);
    }

    @Override
    public void setRequestContentType(String contentType) {
        this.request.setContentType(contentType);
    }

    @Override
    public void addRequestHeaders(Map<String, String> headers) {
        this.request.addHeaders(headers);
    }

    @Override
    public long getResponseContentLength() {
        return this.response.getContentLength();
    }

    @Override
    protected String getRequestCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    private class ConnectionResponse
    extends StagingHttpResponse {
        private ConnectionResponse() {
        }

        @Override
        public void addCookie(Cookie cookie) {
            super.addCookie(cookie);
            StagingConnection.this.cookies.add(cookie);
        }
    }

    private class ConnectionRequest
    extends StagingHttpRequest {
        private ConnectionRequest() {
        }

        public Cookie[] getCookies() {
            return StagingConnection.this.cookies.toArray(COOKIE);
        }

        public String getMethod() {
            return StagingConnection.this.getRequestMethod().toString();
        }

        public String getServletPath() {
            return StagingConnection.this.servletPath;
        }

        public String getPathInfo() {
            return StagingConnection.this.pathInfo;
        }

        public String getQueryString() {
            return StagingConnection.this.getRequestQueryString();
        }

        public String getRequestURI() {
            return StagingConnection.this.url.getPath();
        }

        @Override
        public String getServerName() {
            return StagingConnection.this.url.getHost();
        }

        @Override
        public int getLocalPort() {
            int port = StagingConnection.this.url.getPort();
            if (port < 0) {
                port = super.getLocalPort();
            }
            return port;
        }

        @Override
        public String getParameter(String name) {
            String[] values = StagingConnection.this.getRequestParameters().get(name);
            if (null != values && values.length > 0) {
                return values[0];
            }
            return null;
        }

        public Map getParameterMap() {
            return Collections.unmodifiableMap(StagingConnection.this.getRequestParameters());
        }

        public Enumeration getParameterNames() {
            return Collections.enumeration(StagingConnection.this.getRequestParameters().keySet());
        }

        @Override
        public String[] getParameterValues(String name) {
            return StagingConnection.this.getRequestParameters().get(name);
        }

        public HttpSession getSession() {
            return StagingConnection.this.server.getSession();
        }

        @Override
        public HttpSession getSession(boolean create) {
            return StagingConnection.this.server.getSession(create);
        }

        @Override
        public RequestDispatcher getRequestDispatcher(String path) {
            RequestChain dispatchedServlet;
            RequestDispatcher dispatcher = null;
            if (!path.startsWith("/")) {
                try {
                    URL absoluteUrl = new URL(StagingConnection.this.url, path);
                    path = absoluteUrl.getFile();
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }
            if (null != (dispatchedServlet = StagingConnection.this.server.getServlet(path))) {
                dispatcher = new RequestDispatcher(){

                    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
                        response.reset();
                        dispatchedServlet.execute(request, response);
                    }

                    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
                        dispatchedServlet.execute(request, response);
                    }
                };
            }
            return dispatcher;
        }

        @Override
        protected void attributeAdded(String name, Object o) {
            StagingConnection.this.server.requestAttributeAdded((ServletRequest)this, name, o);
        }

        @Override
        protected void attributeRemoved(String name, Object removed) {
            StagingConnection.this.server.requestAttributeRemoved((ServletRequest)this, name, removed);
        }

        @Override
        protected void attributeReplaced(String name, Object o) {
            StagingConnection.this.server.requestAttributeReplaced((ServletRequest)this, name, o);
        }
    }
}

