/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.faces.staging;

import javax.el.ELContextListener;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspApplicationContext;
import org.jboss.test.faces.TestException;

public class StaggingJspApplicationContext
implements JspApplicationContext {
    public static final String FACES_EXPRESSION_FACTORY = "com.sun.faces.expressionFactory";
    public static final String SUN_EXPRESSION_FACTORY = "com.sun.el.ExpressionFactoryImpl";
    public static final String JBOSS_EXPRESSION_FACTORY = "org.jboss.el.ExpressionFactoryImpl";
    private ExpressionFactory expressionFactory;
    private final ServletContext servletContext;

    public StaggingJspApplicationContext(ServletContext servletContext) {
        this.servletContext = servletContext;
        String elFactoryClass = servletContext.getInitParameter(FACES_EXPRESSION_FACTORY);
        if (null == elFactoryClass) {
            elFactoryClass = servletContext.getInitParameter(SUN_EXPRESSION_FACTORY);
        }
        try {
            if (null == elFactoryClass) {
                try {
                    this.expressionFactory = this.instantiate(SUN_EXPRESSION_FACTORY);
                }
                catch (ClassNotFoundException e) {
                    this.expressionFactory = this.instantiate(JBOSS_EXPRESSION_FACTORY);
                }
            } else {
                this.expressionFactory = this.instantiate(elFactoryClass);
            }
        }
        catch (Exception e) {
            throw new TestException("Couldn't instantiate EL expression factory", e);
        }
    }

    private ExpressionFactory instantiate(String elFactoryClass) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return Class.forName(elFactoryClass).asSubclass(ExpressionFactory.class).newInstance();
    }

    public void addELContextListener(ELContextListener listener) {
    }

    public void addELResolver(ELResolver resolver) {
    }

    public ExpressionFactory getExpressionFactory() {
        return this.expressionFactory;
    }
}

