/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.faces.staging;

import java.util.regex.Pattern;

public class ServerResourcePath {
    private static final Pattern SLASH = Pattern.compile("/+");
    public static final ServerResourcePath WEB_INF = new ServerResourcePath("/WEB-INF/");
    public static final ServerResourcePath META_INF = new ServerResourcePath("/META-INF/");
    public static final ServerResourcePath WEB_XML = new ServerResourcePath("/WEB-INF/web.xml");
    public static final ServerResourcePath FACES_CONFIG = new ServerResourcePath("/WEB-INF/faces-config.xml");
    private final int pathIndex;
    private final String[] pathElements;

    private ServerResourcePath(String[] pathElements, int pathIndex) {
        this.pathElements = pathElements;
        this.pathIndex = pathIndex;
    }

    public ServerResourcePath(String path) {
        this(ServerResourcePath.splitPath(path), 1);
    }

    private static void checkPath(String path) {
        if (null == path) {
            throw new NullPointerException();
        }
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException(path);
        }
    }

    private static String[] splitPath(String path) {
        ServerResourcePath.checkPath(path);
        return SLASH.split(path);
    }

    public boolean hasNextPath() {
        return this.pathIndex < this.pathElements.length - 1;
    }

    public String getFileName() {
        if (this.pathIndex < this.pathElements.length) {
            return this.pathElements[this.pathIndex];
        }
        return null;
    }

    public ServerResourcePath getNextPath() {
        if (this.hasNextPath()) {
            return new ServerResourcePath(this.pathElements, this.pathIndex + 1);
        }
        return null;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        for (int i = this.pathIndex; i < this.pathElements.length; ++i) {
            str.append("/");
            str.append(this.pathElements[i]);
        }
        if (str.length() == 0) {
            str.append("/");
        }
        return str.toString();
    }
}

