/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.faces.staging;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.test.faces.staging.HttpMethod;

public abstract class HttpConnection {
    private final Map<String, String[]> requestParameters = new HashMap<String, String[]>();
    private HttpMethod method = HttpMethod.GET;

    public void parseFormParameters(String queryString) {
        String[] queryParams = queryString.split("&");
        for (int i = 0; i < queryParams.length; ++i) {
            String par = queryParams[i];
            int eqIndex = par.indexOf(61);
            if (eqIndex >= 0) {
                String name = this.decode(par.substring(0, eqIndex));
                String value = this.decode(par.substring(eqIndex + 1));
                this.addRequestParameter(name, value);
                continue;
            }
            this.addRequestParameter(this.decode(par), null);
        }
    }

    protected String decode(String value) {
        if (null != this.getRequestCharacterEncoding()) {
            try {
                return URLDecoder.decode(value, this.getRequestCharacterEncoding());
            }
            catch (UnsupportedEncodingException e) {
                return URLDecoder.decode(value);
            }
        }
        return URLDecoder.decode(value);
    }

    protected abstract String getRequestCharacterEncoding();

    public abstract boolean isFinished();

    public abstract boolean isStarted();

    public abstract void execute();

    public abstract void finish();

    public abstract void start();

    public abstract String getContentAsString();

    public abstract byte[] getResponseBody();

    public abstract String getResponseCharacterEncoding();

    public abstract String getResponseContentType();

    public abstract int getResponseStatus();

    public abstract String getErrorMessage();

    public abstract Map<String, String[]> getResponseHeaders();

    public abstract void setRequestCharacterEncoding(String var1) throws UnsupportedEncodingException;

    public abstract void setRequestBody(String var1);

    public abstract void setRequestContentType(String var1);

    public abstract long getResponseContentLength();

    public abstract HttpServletResponse getResponse();

    public abstract HttpServletRequest getRequest();

    public abstract void addRequestHeaders(Map<String, String> var1);

    public void addRequestParameter(String name, String value) {
        String[] values = this.getRequestParameters().get(name);
        if (null == values) {
            values = new String[1];
        } else {
            String[] newValues = new String[values.length + 1];
            System.arraycopy(values, 0, newValues, 0, values.length);
            values = newValues;
        }
        values[values.length - 1] = value;
        this.getRequestParameters().put(name, values);
    }

    protected String getRequestQueryString() {
        StringBuilder queryString = new StringBuilder();
        for (Map.Entry<String, String[]> entry : this.getRequestParameters().entrySet()) {
            if (null == entry.getValue()) continue;
            for (String value : entry.getValue()) {
                if (queryString.length() > 0) {
                    queryString.append("&");
                }
                queryString.append(this.encode(entry.getKey()));
                if (null == value) continue;
                queryString.append("=").append(this.encode(value));
            }
        }
        return queryString.length() > 0 ? queryString.toString() : null;
    }

    private String encode(String entry) {
        try {
            return URLEncoder.encode(entry, this.getRequestCharacterEncoding());
        }
        catch (UnsupportedEncodingException e) {
            return URLEncoder.encode(entry);
        }
    }

    protected Map<String, String[]> getRequestParameters() {
        return this.requestParameters;
    }

    public HttpMethod getRequestMethod() {
        return this.method;
    }

    public void setRequestMethod(HttpMethod method) {
        this.method = method;
    }
}

