/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.faces.staging;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jboss.test.faces.staging.DirectoryMapAdapter;
import org.jboss.test.faces.staging.ServerResourcePath;

public class DirectoryMap<Resource, Directory extends Resource> {
    private final Map<String, Resource> children = new TreeMap<String, Resource>();
    private final Directory directory;
    private final DirectoryMapAdapter<Resource, Directory> adapter;

    public DirectoryMap(Directory directory, DirectoryMapAdapter<Resource, Directory> instance) {
        this.directory = directory;
        this.adapter = instance;
    }

    private void putChild(String fileName, Resource child) {
        Resource previousChild = this.children.put(fileName, child);
        if (previousChild != null) {
            // empty if block
        }
    }

    public Directory addDirectory(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException();
        }
        Resource childResource = this.children.get(fileName);
        Directory result = this.adapter.asDirectory(childResource);
        if (result == null) {
            String resourcePath = this.adapter.getResourcePath(this.directory);
            if (resourcePath == null) {
                resourcePath = "";
            }
            result = this.adapter.createChildDirectory(resourcePath + "/" + fileName);
            this.putChild(fileName, result);
        }
        return result;
    }

    public Directory addDirectory(ServerResourcePath path) {
        String fileName;
        if (null == path) {
            throw new IllegalArgumentException();
        }
        Directory result = this.directory;
        for (ServerResourcePath subPath = path; subPath != null && (fileName = subPath.getFileName()) != null; subPath = subPath.getNextPath()) {
            result = this.adapter.addDirectory(result, fileName);
        }
        return result;
    }

    public void addResource(ServerResourcePath path, Resource resource) {
        if (null == path) {
            throw new IllegalArgumentException();
        }
        String fileName = path.getFileName();
        if (fileName == null) {
            throw new IllegalArgumentException();
        }
        if (path.hasNextPath()) {
            Directory childResource = this.addDirectory(fileName);
            this.adapter.addResource(childResource, path.getNextPath(), resource);
        } else {
            this.putChild(fileName, resource);
        }
    }

    public Resource getResource(ServerResourcePath path) {
        if (null == path) {
            throw new NullPointerException();
        }
        Object resource = null;
        String fileName = path.getFileName();
        if (fileName == null) {
            resource = this.directory;
        } else {
            resource = this.children.get(fileName);
            if (resource != null && path.hasNextPath()) {
                resource = this.adapter.getResource(resource, path.getNextPath());
            }
        }
        return resource;
    }

    public Set<String> getResourceNames() {
        return this.children.keySet();
    }

    public Collection<Resource> getResources() {
        return this.children.values();
    }

    public void clear() {
        this.children.clear();
    }
}

