/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.faces.staging;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Set;
import java.util.logging.Logger;
import org.jboss.test.faces.staging.ServerLogger;
import org.jboss.test.faces.staging.ServerResource;
import org.jboss.test.faces.staging.ServerResourcePath;

public abstract class AbstractServerResource
implements ServerResource {
    private static final Logger log = ServerLogger.RESOURCE.getLogger();

    @Override
    public InputStream getAsStream() throws IOException {
        URL url = this.getURL();
        if (url != null) {
            URLConnection connection = url.openConnection();
            try {
                connection.setUseCaches(false);
            }
            catch (IllegalArgumentException e) {
                log.info("RESOURCE_NOT_CACHEABLE");
            }
            return connection.getInputStream();
        }
        return null;
    }

    @Override
    public void addResource(ServerResourcePath path, ServerResource resource) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ServerResource getResource(ServerResourcePath path) {
        if (null == path) {
            throw new NullPointerException();
        }
        if (!path.hasNextPath()) {
            return this;
        }
        return null;
    }

    @Override
    public Set<String> getPaths() {
        return null;
    }
}

