/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.faces;

import java.util.concurrent.CountDownLatch;
import org.jboss.test.faces.Threads;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public final class ThreadsRule
implements MethodRule {
    public Statement apply(final Statement statement, final FrameworkMethod frameworkMethod, Object o) {
        final Threads concurrent = (Threads)frameworkMethod.getAnnotation(Threads.class);
        if (concurrent == null) {
            return statement;
        }
        return new Statement(){

            public void evaluate() throws Throwable {
                String name = frameworkMethod.getName();
                Thread[] threads = new Thread[concurrent.value()];
                final CountDownLatch go = new CountDownLatch(1);
                final CountDownLatch finished = new CountDownLatch(threads.length);
                for (int i = 0; i < threads.length; ++i) {
                    threads[i] = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                go.await();
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                            try {
                                statement.evaluate();
                            }
                            catch (Error e) {
                                throw e;
                            }
                            catch (RuntimeException r) {
                                throw r;
                            }
                            catch (Throwable throwable) {
                                RuntimeException r = new RuntimeException(throwable.getMessage(), throwable);
                                r.setStackTrace(throwable.getStackTrace());
                                throw r;
                            }
                            finally {
                                finished.countDown();
                            }
                        }
                    }, name + "-Thread-" + i);
                    threads[i].start();
                }
                go.countDown();
                finished.await();
            }
        };
    }
}

