/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.faces;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EventListener;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.lifecycle.Lifecycle;
import javax.servlet.Filter;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import org.jboss.test.faces.ApplicationServer;
import org.jboss.test.faces.FacesEnvironment;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class FacesRule
implements MethodRule,
ServletRequestListener {
    private final FacesEnvironment environment;

    protected FacesRule(FacesEnvironment environment) {
        this.environment = environment;
        this.environment.getServer().addWebListener((EventListener)((Object)this));
    }

    public static FacesRule create() {
        return new FacesRule(new FacesEnvironment());
    }

    public static FacesRule create(ApplicationServer server) {
        return new FacesRule(new FacesEnvironment(server));
    }

    public final Statement apply(final Statement base, FrameworkMethod method, Object target) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                FacesRule.this.before();
                try {
                    base.evaluate();
                }
                finally {
                    FacesRule.this.after();
                }
            }
        };
    }

    protected void before() throws Throwable {
        this.environment.start();
    }

    protected void after() {
        this.environment.release();
    }

    public ApplicationServer getServer() {
        return this.environment.getServer();
    }

    public FacesRule withFilter(String name, Filter filter) {
        this.environment.withFilter(name, filter);
        return this;
    }

    public FacesRule withWebRoot(File root) {
        this.environment.withWebRoot(root);
        return this;
    }

    public FacesRule withWebRoot(URL root) {
        this.environment.withWebRoot(root);
        return this;
    }

    public FacesRule withWebRoot(String root) {
        this.environment.withWebRoot(root);
        return this;
    }

    public FacesRule withInitParameter(String name, String value) {
        this.environment.withInitParameter(name, value);
        return this;
    }

    public FacesRule withResource(String path, String resource) {
        this.environment.withResource(path, resource);
        return this;
    }

    public FacesRule withResource(String path, URL resource) {
        this.environment.withResource(path, resource);
        return this;
    }

    public FacesRule withContent(String path, String pageContent) {
        this.environment.withContent(path, pageContent);
        return this;
    }

    public FacesRule withListener(EventListener listener) {
        this.environment.getServer().addWebListener(listener);
        return this;
    }

    public void setSessionAttribute(String name, Object value) {
        this.environment.getServer().getSession().setAttribute(name, value);
    }

    public void setContextAttribute(String name, Object value) {
        this.environment.getServer().getContext().setAttribute(name, value);
    }

    public Lifecycle getLifecycle() {
        return this.environment.getLifecycle();
    }

    public Application getApplication() {
        return this.environment.getApplication();
    }

    public FacesEnvironment.FacesRequest createFacesRequest() throws Exception {
        return this.environment.createFacesRequest();
    }

    public FacesEnvironment.FacesRequest createFacesRequest(String url) throws MalformedURLException, FacesException {
        return this.environment.createFacesRequest(url);
    }

    public void requestDestroyed(ServletRequestEvent sre) {
    }

    public void requestInitialized(ServletRequestEvent sre) {
    }
}

