/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.faces;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.webapp.FacesServlet;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.jboss.test.faces.ApplicationServer;
import org.jboss.test.faces.FilterHolder;
import org.jboss.test.faces.ServletHolder;
import org.jboss.test.faces.TestException;
import org.jboss.test.faces.staging.HttpConnection;
import org.jboss.test.faces.staging.HttpMethod;

public class FacesEnvironment {
    public static final String WEB_XML = "/WEB-INF/web.xml";
    public static final String FACES_CONFIG_XML = "/WEB-INF/faces-config.xml";
    private List<FacesRequest> requests = new CopyOnWriteArrayList<FacesRequest>();
    private ClassLoader contextClassLoader;
    private ApplicationServer facesServer;
    private Lifecycle lifecycle;
    private Application application;
    private boolean initialized = false;
    private ServletHolder facesServletContainer;
    private FilterHolder filterContainer;
    private String webXmlDefault;
    private File webRoot;
    static final Pattern INPUT_PATTERN = Pattern.compile("<input([^>]+)>", 40);
    static final Pattern NAME_PATTERN = Pattern.compile("name=[\"']([^\"']*)[\"']");
    static final Pattern VALUE_PATTERN = Pattern.compile("value=[\"']([^\"']*)[\"']");

    public FacesEnvironment() {
        this(ApplicationServer.createApplicationServer());
    }

    public FacesEnvironment(ApplicationServer applicationServer) {
        this.facesServer = applicationServer;
        this.setupFacesServlet();
        this.setupFacesListener();
        this.setupJsfInitParameters();
        this.setupWebContent();
    }

    public ApplicationServer getServer() {
        return this.facesServer;
    }

    public Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    public Application getApplication() {
        return this.application;
    }

    public FacesEnvironment withFilter(String name, Filter filter) {
        this.checkNotInitialized();
        this.filterContainer = new FilterHolder(this.facesServletContainer.getMapping(), filter);
        this.filterContainer.setName(name);
        return this;
    }

    public FacesEnvironment withRichFaces() {
        this.checkNotInitialized();
        try {
            Filter ajaxFilter = (Filter)this.createInstance("org.ajax4jsf.Filter");
            this.withFilter("ajax4jsf", ajaxFilter);
            this.webXmlDefault = "org/jboss/test/faces/ajax-web.xml";
            return this;
        }
        catch (ClassNotFoundException e) {
            throw new TestException(e);
        }
    }

    public FacesEnvironment withSeam() {
        this.checkNotInitialized();
        try {
            Filter ajaxFilter = (Filter)this.createInstance("org.jboss.seam.servlet.SeamFilter");
            this.withFilter("ajax4jsf", ajaxFilter);
            EventListener seamListener = (EventListener)this.createInstance("org.jboss.seam.servlet.SeamListener");
            this.facesServer.addWebListener(seamListener);
            this.webXmlDefault = "org/jboss/test/faces/ajax-web.xml";
            return this;
        }
        catch (ClassNotFoundException e) {
            throw new TestException(e);
        }
    }

    public FacesEnvironment withWebRoot(File root) {
        this.checkNotInitialized();
        this.webRoot = root;
        return this;
    }

    public FacesEnvironment withWebRoot(URL root) {
        this.checkNotInitialized();
        this.facesServer.addResourcesFromDirectory("/", root);
        this.webRoot = null;
        return this;
    }

    public FacesEnvironment withWebRoot(String root) {
        this.checkNotInitialized();
        return this.withWebRoot(FacesEnvironment.class.getClassLoader().getResource(root));
    }

    public FacesEnvironment withInitParameter(String name, String value) {
        this.checkNotInitialized();
        this.facesServer.addInitParameter(name, value);
        return this;
    }

    public FacesEnvironment withResource(String path, String resource) {
        this.facesServer.addResource(path, resource);
        return this;
    }

    public FacesEnvironment withResource(String path, URL resource) {
        this.facesServer.addResource(path, resource);
        return this;
    }

    public FacesEnvironment withResourcesFromDirectory(String path, URL resource) {
        this.facesServer.addResourcesFromDirectory(path, resource);
        return this;
    }

    public FacesEnvironment withContent(String path, String pageContent) {
        this.facesServer.addContent(path, pageContent);
        return this;
    }

    public FacesEnvironment start() {
        this.contextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        this.facesServer.addResource(WEB_XML, this.webXmlDefault);
        if (null != this.webRoot) {
            this.facesServer.addResourcesFromDirectory("/", this.webRoot);
        }
        this.facesServer.addServlet(this.facesServletContainer);
        if (this.filterContainer != null) {
            this.facesServer.addFilter(this.filterContainer);
        }
        this.facesServer.init();
        ApplicationFactory applicationFactory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
        this.application = applicationFactory.getApplication();
        LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        this.lifecycle = lifecycleFactory.getLifecycle("DEFAULT");
        this.initialized = true;
        return this;
    }

    protected void setupFacesListener() {
        EventListener listener = null;
        try {
            listener = (EventListener)this.createInstance("com.sun.faces.config.ConfigureListener");
            this.setupSunFaces();
        }
        catch (ClassNotFoundException e) {
            try {
                listener = (EventListener)this.createInstance("org.apache.myfaces.webapp.StartupServletContextListener");
                this.setupMyFaces();
            }
            catch (ClassNotFoundException e1) {
                throw new TestException("No JSF listeners have been found", e1);
            }
        }
        this.facesServer.addWebListener(listener);
    }

    protected void setupFacesServlet() {
        this.facesServletContainer = new ServletHolder("*.jsf", (Servlet)new FacesServlet());
        this.facesServletContainer.setName("Faces Servlet");
        this.webXmlDefault = "org/jboss/test/faces/web.xml";
    }

    protected void setupJsfInitParameters() {
        this.facesServer.addInitParameter("javax.faces.STATE_SAVING_METHOD", "server");
        this.facesServer.addInitParameter("javax.faces.DEFAULT_SUFFIX", ".xhtml");
        this.facesServer.addInitParameter("javax.faces.PROJECT_STAGE", "UnitTest");
    }

    protected void setupMyFaces() {
    }

    protected void setupSunFaces() {
        this.facesServer.addInitParameter("com.sun.faces.validateXml", "true");
        this.facesServer.addInitParameter("com.sun.faces.verifyObjects", "true");
    }

    protected void setupWebContent() {
        String webappDirectory = System.getProperty("webroot");
        this.webRoot = null;
        if (null == webappDirectory) {
            URL resource = this.getClass().getResource("/webapp.properties");
            if (null != resource && "file".equals(resource.getProtocol())) {
                Properties webProperties = new Properties();
                try {
                    InputStream inputStream = resource.openStream();
                    webProperties.load(inputStream);
                    inputStream.close();
                    this.webRoot = new File(resource.getPath());
                    this.webRoot = new File(this.webRoot.getParentFile(), webProperties.getProperty("webroot")).getAbsoluteFile();
                }
                catch (IOException e) {
                    throw new TestException(e);
                }
            }
        } else {
            this.webRoot = new File(webappDirectory);
        }
    }

    public FacesRequest createFacesRequest() throws Exception {
        String url = "http://localhost/test.jsf";
        return this.createFacesRequest(url).withViewId("/test.xhtml");
    }

    public FacesRequest createFacesRequest(String url) throws MalformedURLException, FacesException {
        FacesRequest request = new FacesRequest();
        request.connection = this.getServer().getConnection(new URL(url));
        this.requests.add(request);
        return request;
    }

    public void release() {
        this.checkInitialized();
        for (FacesRequest request : this.requests) {
            request.release();
        }
        this.facesServer.destroy();
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        this.facesServer = null;
        this.application = null;
        this.lifecycle = null;
        this.initialized = false;
    }

    private void checkInitialized() {
        if (!this.initialized) {
            throw new TestException("JSF test environment has not been initialized");
        }
    }

    private void checkNotInitialized() {
        if (this.initialized) {
            throw new TestException("JSF test environment has already been initialized");
        }
    }

    private <T> T createInstance(String className) throws TestException, ClassNotFoundException {
        try {
            Class<?> clazz = FacesEnvironment.class.getClassLoader().loadClass(className);
            return (T)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TestException(e);
        }
    }

    public static FacesEnvironment createEnvironment() {
        return new FacesEnvironment();
    }

    public static FacesEnvironment createEnvironment(ApplicationServer applicationServer) {
        return new FacesEnvironment(applicationServer);
    }

    public static Collection<String> getInputFields(String content) {
        ArrayList<String> inputs = new ArrayList<String>();
        Matcher matcher = INPUT_PATTERN.matcher(content);
        while (matcher.find()) {
            inputs.add(matcher.group(1));
        }
        return inputs;
    }

    public static Map<String, String> getHiddenFields(String content) {
        Collection<String> inputFields = FacesEnvironment.getInputFields(content);
        HashMap<String, String> parameters = new HashMap<String, String>(inputFields.size());
        for (String string : inputFields) {
            Matcher matcher;
            if (!string.contains("type='hidden'") && !string.contains("type=\"hidden\"") || !(matcher = NAME_PATTERN.matcher(string)).find()) continue;
            String name = matcher.group(1);
            Matcher valueMatcher = VALUE_PATTERN.matcher(string);
            if (valueMatcher.find()) {
                parameters.put(name, valueMatcher.group(1));
                continue;
            }
            parameters.put(name, "");
        }
        return parameters;
    }

    public class FacesRequest {
        private HttpConnection connection;
        private FacesContext facesContext;
        private String viewId;

        public FacesRequest start() {
            if (this.connection.isStarted() || this.connection.isFinished()) {
                throw new IllegalStateException();
            }
            this.connection.start();
            FacesContextFactory facesContextFactory = (FacesContextFactory)FactoryFinder.getFactory((String)"javax.faces.context.FacesContextFactory");
            this.facesContext = facesContextFactory.getFacesContext((Object)FacesEnvironment.this.facesServer.getContext(), (Object)this.connection.getRequest(), (Object)this.connection.getResponse(), FacesEnvironment.this.lifecycle);
            if (null != this.viewId) {
                this.facesContext.setViewRoot(FacesEnvironment.this.application.getViewHandler().createView(this.facesContext, this.viewId));
            }
            return this;
        }

        public FacesRequest finish() {
            if (!this.connection.isStarted() || this.connection.isFinished()) {
                throw new IllegalStateException();
            }
            this.connection.finish();
            return this;
        }

        public byte[] execute() {
            if (this.connection.isStarted() || this.connection.isFinished()) {
                throw new IllegalStateException();
            }
            this.connection.execute();
            return this.connection.getResponseBody();
        }

        public FacesRequest withViewId(String viewId) {
            if (this.connection.isStarted() || this.connection.isFinished()) {
                throw new IllegalStateException();
            }
            this.viewId = viewId;
            return this;
        }

        public FacesRequest withParameter(String name, String value) {
            this.connection.addRequestParameter(name, value);
            return this;
        }

        public String getResponseAsString() {
            return this.connection.getContentAsString();
        }

        public void release() {
            if (null != this.facesContext) {
                this.facesContext.release();
                this.facesContext = null;
            }
            if (null != this.connection) {
                if (!this.connection.isFinished()) {
                    this.connection.finish();
                }
                this.connection = null;
            }
            FacesEnvironment.this.requests.remove(this);
        }

        public HttpConnection getConnection() {
            return this.connection;
        }

        public FacesRequest submit() throws MalformedURLException, FacesException {
            if (!this.connection.isFinished()) {
                throw new IllegalStateException();
            }
            Map<String, String> fields = FacesEnvironment.getHiddenFields(this.connection.getContentAsString());
            if (!fields.containsKey("javax.faces.ViewState")) {
                throw new FacesException("No view state field in response");
            }
            FacesRequest facesRequest = FacesEnvironment.this.createFacesRequest(this.connection.getRequest().getRequestURL().toString()).withViewId(this.viewId);
            facesRequest.connection.setRequestMethod(HttpMethod.POST);
            for (Map.Entry<String, String> entry : fields.entrySet()) {
                facesRequest.withParameter(entry.getKey(), entry.getValue());
            }
            return facesRequest;
        }
    }
}

