/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.faces;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.jboss.test.faces.FilterHolder;
import org.jboss.test.faces.ServletHolder;
import org.jboss.test.faces.TestException;
import org.jboss.test.faces.staging.HttpConnection;
import org.jboss.test.faces.staging.ServerLogger;
import org.jboss.test.faces.staging.StagingServer;

public abstract class ApplicationServer {
    private static final Logger log = ServerLogger.RESOURCE.getLogger();
    public static final String APPLICATION_SERVER_PROPERTY = ApplicationServer.class.getName();

    protected void addResourcesFromFile(String resourcePath, URL resource) {
        File file = new File(resource.getPath());
        if (!file.isDirectory()) {
            file = file.getParentFile();
        }
        try {
            this.addFiles(resourcePath, file);
        }
        catch (MalformedURLException e) {
            throw new TestException(e);
        }
    }

    protected void addResourcesFromJar(String resourcePath, URL resource) {
        try {
            String jarPath = resource.getPath();
            String entry = jarPath.substring(jarPath.indexOf(33) + 2);
            jarPath = jarPath.substring(0, jarPath.indexOf(33));
            File file = new File(new URI(jarPath));
            ZipFile zip = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            entry = entry.substring(0, entry.lastIndexOf(47) + 1);
            while (entries.hasMoreElements()) {
                ZipEntry zzz = entries.nextElement();
                if (!zzz.getName().startsWith(entry) || zzz.isDirectory()) continue;
                String relativePath = zzz.getName().substring(entry.length());
                URL relativeResource = new URL(resource, relativePath);
                this.addResource(resourcePath + "/" + relativePath, relativeResource);
            }
        }
        catch (IOException e) {
            throw new TestException("Error read Jar content", e);
        }
        catch (URISyntaxException e) {
            throw new TestException(e);
        }
    }

    protected void addFiles(String resourcePath, File file) throws MalformedURLException {
        File[] files;
        for (File subfile : files = file.listFiles()) {
            if (!subfile.isDirectory()) {
                this.addResource(resourcePath + "/" + subfile.getName(), subfile.toURI().toURL());
                continue;
            }
            String directoryPath = resourcePath + "/" + subfile.getName();
            this.addDirectory(directoryPath);
            this.addFiles(directoryPath, subfile);
        }
    }

    protected abstract void addDirectory(String var1);

    public abstract void addServlet(ServletHolder var1);

    public abstract void addFilter(FilterHolder var1);

    public abstract void addInitParameter(String var1, String var2);

    public abstract void addMimeType(String var1, String var2);

    public abstract void addContent(String var1, String var2);

    public abstract void addResource(String var1, String var2);

    public abstract void addResource(String var1, URL var2);

    public void addResourcesFromDirectory(String path, URL resource) {
        String protocol = resource.getProtocol();
        if ("jar".equals(protocol)) {
            this.addResourcesFromJar(path, resource);
        } else if ("file".equals(protocol)) {
            this.addResourcesFromFile(path, resource);
        } else {
            throw new TestException("Unsupported protocol " + protocol);
        }
    }

    public void addResourcesFromDirectory(String path, File directory) {
        if (!directory.exists()) {
            throw new TestException("directory does not exist:" + directory.getAbsolutePath());
        }
        try {
            this.addFiles(path, directory);
        }
        catch (MalformedURLException e) {
            throw new TestException(e);
        }
    }

    public abstract void addWebListener(EventListener var1);

    public abstract void init();

    public abstract void destroy();

    public abstract ServletContext getContext();

    public abstract int getPort();

    public abstract HttpConnection getConnection(URL var1);

    public abstract boolean isSessionPerThread();

    public abstract void setSessionPerThread(boolean var1);

    public abstract HttpSession getSession();

    public abstract HttpSession getSession(boolean var1);

    public static ApplicationServer createApplicationServer() {
        String applicationServerClassName = System.getProperty(APPLICATION_SERVER_PROPERTY);
        if (applicationServerClassName != null) {
            return ApplicationServer.createApplicationServer(applicationServerClassName);
        }
        return new StagingServer();
    }

    private static ApplicationServer createApplicationServer(String applicationServerClassName) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ApplicationServer.class.getClassLoader();
        }
        try {
            Class<?> applicationServer = Class.forName(applicationServerClassName, true, classLoader);
            Class<ApplicationServer> applicationServerClass = applicationServer.asSubclass(ApplicationServer.class);
            return applicationServerClass.newInstance();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            throw new TestException(e);
        }
    }
}

