/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.faces;

import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;

public abstract class AbstractThreadedTest
extends TestCase {
    private Thread[] threads = null;
    private TestResult testResult = null;

    public void interruptThreads() {
        if (this.threads != null) {
            for (int i = 0; i < this.threads.length; ++i) {
                this.threads[i].interrupt();
            }
        }
    }

    public void run(TestResult result) {
        this.testResult = result;
        super.run(result);
        this.testResult = null;
    }

    protected void runTestCaseThreads(Class<?> clazz, int numThreads) {
        TestCaseRunnable[] runnables = new TestCaseRunnable[numThreads];
        for (int i = 0; i < runnables.length; ++i) {
            try {
                runnables[i] = (TestCaseRunnable)clazz.newInstance();
                continue;
            }
            catch (Exception e) {
                this.testResult.addError((Test)this, (Throwable)e);
                return;
            }
        }
        this.runTestCaseRunnables(runnables);
    }

    protected void runTestCaseRunnables(TestCaseRunnable[] runnables) {
        int i;
        if (runnables == null) {
            throw new IllegalArgumentException("runnables is null");
        }
        this.threads = new Thread[runnables.length];
        for (i = 0; i < this.threads.length; ++i) {
            this.threads[i] = new Thread(runnables[i]);
        }
        for (i = 0; i < this.threads.length; ++i) {
            this.threads[i].start();
        }
        try {
            for (i = 0; i < this.threads.length; ++i) {
                this.threads[i].join();
            }
        }
        catch (InterruptedException ignore) {
            System.out.println("Thread join interrupted.");
        }
        this.threads = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleException(Throwable t) {
        TestResult testResult = this.testResult;
        synchronized (testResult) {
            if (t instanceof AssertionFailedError) {
                this.testResult.addFailure((Test)this, (AssertionFailedError)t);
            } else {
                this.testResult.addError((Test)this, t);
            }
        }
    }

    public abstract class TestCaseRunnable
    implements Runnable {
        public abstract void runTestCase() throws Throwable;

        @Override
        public void run() {
            try {
                this.runTestCase();
            }
            catch (Throwable t) {
                AbstractThreadedTest.this.handleException(t);
                AbstractThreadedTest.this.interruptThreads();
            }
        }
    }
}

