/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.faces;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EventListener;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.LogManager;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.webapp.FacesServlet;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import junit.framework.TestCase;
import org.jboss.test.faces.FilterHolder;
import org.jboss.test.faces.ServletHolder;
import org.jboss.test.faces.TestException;
import org.jboss.test.faces.staging.HttpConnection;
import org.jboss.test.faces.staging.StagingServer;
import org.junit.After;
import org.junit.Before;

public abstract class AbstractFacesTest
extends TestCase {
    private ClassLoader contextClassLoader;
    protected StagingServer facesServer;
    protected HttpConnection connection;
    protected FacesContext facesContext;
    protected Lifecycle lifecycle;
    protected Application application;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void setUp() throws Exception {
        this.contextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream("logging.properties");
        if (null != stream) {
            try {
                LogManager.getLogManager().readConfiguration(stream);
            }
            catch (Exception e) {
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
        this.facesServer = new StagingServer();
        this.setupFacesServlet();
        this.setupFacesListener();
        this.setupJsfInitParameters();
        this.setupWebContent();
        this.facesServer.init();
        ApplicationFactory applicationFactory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
        this.application = applicationFactory.getApplication();
        LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        this.lifecycle = lifecycleFactory.getLifecycle("DEFAULT");
    }

    protected void setupFacesListener() {
        EventListener listener = null;
        try {
            Class<EventListener> listenerClass = this.contextClassLoader.loadClass("com.sun.faces.config.ConfigureListener").asSubclass(EventListener.class);
            listener = listenerClass.newInstance();
            this.setupSunFaces();
        }
        catch (ClassNotFoundException e) {
            try {
                Class<EventListener> listenerClass = this.contextClassLoader.loadClass("org.apache.myfaces.webapp.StartupServletContextListener").asSubclass(EventListener.class);
                listener = listenerClass.newInstance();
                this.setupMyFaces();
            }
            catch (ClassNotFoundException e1) {
                throw new TestException("No JSF listeners have been found", e1);
            }
            catch (Exception e2) {
                throw new TestException("Error instantiate MyFaces listener", e2);
            }
        }
        catch (Exception e) {
            throw new TestException("Error instantiate JSF RI listener", e);
        }
        this.facesServer.addWebListener(listener);
    }

    protected void setupFacesServlet() {
        ServletHolder facesServletContainer = new ServletHolder("*.jsf", (Servlet)new FacesServlet());
        facesServletContainer.setName("Faces Servlet");
        this.facesServer.addServlet(facesServletContainer);
        try {
            Class<Filter> ajaxFilterClass = this.contextClassLoader.loadClass("org.ajax4jsf.Filter").asSubclass(Filter.class);
            Filter ajaxFilter = ajaxFilterClass.newInstance();
            FilterHolder filterHolder = new FilterHolder("*.jsf", ajaxFilter);
            filterHolder.setName("ajax4jsf");
            this.facesServer.addResource("/WEB-INF/web.xml", "org/jboss/test/faces/ajax-web.xml");
            this.facesServer.addFilter(filterHolder);
        }
        catch (ClassNotFoundException e) {
            this.facesServer.addResource("/WEB-INF/web.xml", "org/jboss/test/faces/web.xml");
        }
        catch (Exception e) {
            throw new TestException(e);
        }
    }

    protected void setupJsfInitParameters() {
        this.facesServer.addInitParameter("javax.faces.STATE_SAVING_METHOD", "server");
        this.facesServer.addInitParameter("javax.faces.DEFAULT_SUFFIX", ".xhtml");
        this.facesServer.addInitParameter("javax.faces.PROJECT_STAGE", ProjectStage.UnitTest.name());
    }

    protected void setupMyFaces() {
    }

    protected void setupSunFaces() {
        this.facesServer.addInitParameter("com.sun.faces.validateXml", "true");
        this.facesServer.addInitParameter("com.sun.faces.verifyObjects", "true");
    }

    protected void setupWebContent() {
        String webappDirectory = System.getProperty("webroot");
        File webFile = null;
        if (null == webappDirectory) {
            URL resource = ((Object)((Object)this)).getClass().getResource("/webapp.properties");
            if (null != resource && "file".equals(resource.getProtocol())) {
                Properties webProperties = new Properties();
                try {
                    InputStream inputStream = resource.openStream();
                    webProperties.load(inputStream);
                    inputStream.close();
                    webFile = new File(resource.getPath());
                    webFile = new File(webFile.getParentFile(), webProperties.getProperty("webroot")).getAbsoluteFile();
                    this.facesServer.addResourcesFromDirectory("/", webFile);
                }
                catch (IOException e) {
                    throw new TestException(e);
                }
            }
        } else {
            webFile = new File(webappDirectory);
            this.facesServer.addResourcesFromDirectory("/", webFile);
        }
    }

    protected void setupFacesRequest() throws Exception {
        String url = "http://localhost/test.jsf";
        this.setupFacesRequest(url);
        UIViewRoot viewRoot = this.setupView();
        if (null != viewRoot) {
            this.facesContext.setViewRoot(viewRoot);
        }
    }

    protected void setupFacesRequest(String url) throws MalformedURLException, FacesException {
        this.connection = this.facesServer.getConnection(new URL(url));
        this.setupConnection();
        this.connection.start();
        FacesContextFactory facesContextFactory = (FacesContextFactory)FactoryFinder.getFactory((String)"javax.faces.context.FacesContextFactory");
        this.facesContext = facesContextFactory.getFacesContext((Object)this.facesServer.getContext(), (Object)this.connection.getRequest(), (Object)this.connection.getResponse(), this.lifecycle);
    }

    protected UIViewRoot setupView() {
        UIViewRoot viewRoot = (UIViewRoot)this.application.createComponent("javax.faces.ViewRoot");
        viewRoot.setViewId("/test.xhtml");
        viewRoot.setLocale(Locale.getDefault());
        viewRoot.setRenderKitId("HTML_BASIC");
        return viewRoot;
    }

    protected void setupConnection() {
    }

    @After
    public void tearDown() throws Exception {
        if (null != this.facesContext) {
            this.facesContext.release();
            this.facesContext = null;
        }
        if (null != this.connection) {
            if (!this.connection.isFinished()) {
                this.connection.finish();
            }
            this.connection = null;
        }
        this.facesServer.destroy();
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        this.facesServer = null;
        this.application = null;
        this.lifecycle = null;
    }
}

