/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.faces.writer;

import java.io.IOException;
import java.io.Writer;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;
import org.jboss.test.faces.mock.FacesTestException;
import org.jboss.test.faces.writer.Attribute;
import org.jboss.test.faces.writer.CDATARecord;
import org.jboss.test.faces.writer.CommentRecord;
import org.jboss.test.faces.writer.Criteria;
import org.jboss.test.faces.writer.DocumentRecord;
import org.jboss.test.faces.writer.ElementRecord;
import org.jboss.test.faces.writer.Record;
import org.jboss.test.faces.writer.RecordBase;
import org.jboss.test.faces.writer.RecordCriteria;
import org.jboss.test.faces.writer.TextRecord;
import org.jboss.test.faces.writer.URIAttribute;

public class RecordingResponseWriter
extends ResponseWriter {
    private Record content;
    private Record currentRecord;
    private String characterEncoding;
    private String contentType;

    public RecordingResponseWriter(String characterEncoding, String contentType) {
        this.currentRecord = this.content = new RecordBase();
        this.characterEncoding = characterEncoding;
        this.contentType = contentType;
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        throw new UnsupportedOperationException("cloneWithWriter is not yet implemented");
    }

    public void startDocument() throws IOException {
        if (this.currentRecord != this.content) {
            throw new FacesTestException("Start document call not at the root level");
        }
        this.currentRecord = this.content.addRecord(new DocumentRecord());
    }

    public void endDocument() throws IOException {
        if (!(this.currentRecord instanceof DocumentRecord)) {
            throw new FacesTestException("End document call does not match start document");
        }
        this.currentRecord = this.currentRecord.getParent();
    }

    public void startElement(String name, UIComponent component) throws IOException {
        this.currentRecord = this.currentRecord.addRecord(new ElementRecord(name, component));
    }

    public void endElement(String name) throws IOException {
        if (!(this.currentRecord instanceof ElementRecord)) {
            throw new FacesTestException("End element does not match start element call");
        }
        if (!name.equals(this.currentRecord.getName())) {
            throw new FacesTestException("End (" + name + ") element does not match current element " + this.currentRecord.getName());
        }
        this.currentRecord = this.currentRecord.getParent();
    }

    public void writeAttribute(String name, Object value, String property) throws IOException {
        this.currentRecord.addAttribute(new Attribute(name, value, property));
    }

    public void writeURIAttribute(String name, Object value, String property) throws IOException {
        this.currentRecord.addAttribute(new URIAttribute(name, value, property));
    }

    public void writeText(Object text, String property) throws IOException {
        this.currentRecord.addRecord(new TextRecord(text, property));
    }

    public void writeText(char[] text, int off, int len) throws IOException {
        this.currentRecord.addRecord(new TextRecord(String.copyValueOf(text, off, len), null));
    }

    public void writeComment(Object comment) throws IOException {
        this.currentRecord.addRecord(new CommentRecord(comment));
    }

    public void startCDATA() throws IOException {
        this.currentRecord = this.currentRecord.addRecord(new CDATARecord());
    }

    public void endCDATA() throws IOException {
        if (!(this.currentRecord instanceof CDATARecord)) {
            throw new FacesTestException("End CDATA does not match startCDATA ");
        }
        this.currentRecord = this.currentRecord.getParent();
    }

    public void flush() throws IOException {
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void close() throws IOException {
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.currentRecord.addRecord(new TextRecord(String.copyValueOf(cbuf, off, len), null));
    }

    public Criteria find() {
        return new RecordCriteria(this.content);
    }

    public String toString() {
        return this.content.toString();
    }
}

