/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.maven.model.Profile;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.path.DefaultPathTranslator;
import org.apache.maven.model.path.PathTranslator;
import org.apache.maven.model.profile.ProfileActivationContext;
import org.apache.maven.model.profile.ProfileSelector;
import org.apache.maven.model.profile.activation.FileProfileActivator;
import org.apache.maven.model.profile.activation.JdkVersionProfileActivator;
import org.apache.maven.model.profile.activation.OperatingSystemProfileActivator;
import org.apache.maven.model.profile.activation.ProfileActivator;
import org.apache.maven.model.profile.activation.PropertyProfileActivator;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SettingsXmlProfileSelector
implements ProfileSelector {
    private final List<ProfileActivator> activators = new ArrayList<ProfileActivator>();

    public SettingsXmlProfileSelector() {
        this.activators.addAll(Arrays.asList(new JdkVersionProfileActivator(), new PropertyProfileActivator(), new OperatingSystemProfileActivator(), new FileProfileActivator().setPathTranslator((PathTranslator)new DefaultPathTranslator())));
    }

    public List<Profile> getActiveProfiles(Collection<Profile> profiles, ProfileActivationContext context, ModelProblemCollector problems) {
        ArrayList<Profile> activeProfiles = new ArrayList<Profile>();
        block0: for (Profile p : profiles) {
            String id = p.getId();
            if (p.getId() != null && context.getActiveProfileIds().contains(id) && !context.getInactiveProfileIds().contains(id)) {
                activeProfiles.add(p);
            }
            if (p.getActivation() != null && p.getActivation().isActiveByDefault() && !context.getInactiveProfileIds().contains(p.getId())) {
                activeProfiles.add(p);
                break;
            }
            for (ProfileActivator activator : this.activators) {
                if (!activator.isActive(p, context, problems)) continue;
                activeProfiles.add(p);
                continue block0;
            }
        }
        return activeProfiles;
    }

    public static List<String> explicitlyActivatedProfiles(String ... profiles) {
        if (profiles.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> activated = new ArrayList<String>();
        for (String profileId : profiles) {
            Validate.notNullOrEmpty(profileId, "Invalid name (\"" + profileId + "\") of a profile to be activated");
            if (profileId.startsWith("-") || profileId.startsWith("!")) continue;
            activated.add(profileId);
        }
        return activated;
    }

    public static List<String> explicitlyDisabledProfiles(String ... profiles) {
        if (profiles.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> disabled = new ArrayList<String>();
        for (String profileId : profiles) {
            if (profileId == null || !profileId.startsWith("-") && !profileId.startsWith("!")) continue;
            String disabledId = profileId.substring(1);
            Validate.notNullOrEmpty(disabledId, "Invalid name (\"" + profileId + "\") of a profile do be disabled");
            disabled.add(disabledId);
        }
        return disabled;
    }
}

