/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.archive.plugins;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.jboss.shrinkwrap.resolver.api.maven.pom.ParsedPomFile;
import org.jboss.shrinkwrap.resolver.impl.maven.archive.plugins.AbstractPackagingPluginConfiguration;
import org.jboss.shrinkwrap.resolver.impl.maven.archive.plugins.ConfigurationUtils;

public class WarPluginConfiguration
extends AbstractPackagingPluginConfiguration {
    private static final String WAR_PLUGIN_GA = "org.apache.maven.plugins:maven-war-plugin";
    private final File warSourceDirectory;
    private final String[] includes;
    private final String[] excludes;

    public WarPluginConfiguration(ParsedPomFile pomFile) {
        super(pomFile);
        Map rawValues = pomFile.getPluginConfiguration(WAR_PLUGIN_GA);
        this.warSourceDirectory = ConfigurationUtils.valueAsFile(rawValues, new ConfigurationUtils.Key("warSourceDirectory"), pomFile.getBaseDirectory(), new File(pomFile.getBaseDirectory(), "src/main/webapp"));
        ArrayList<String> excludes = new ArrayList<String>();
        excludes.addAll(ConfigurationUtils.valueAsStringList(rawValues, new ConfigurationUtils.Key("excludes", "exclude"), Collections.emptyList()));
        excludes.addAll(ConfigurationUtils.valueAsStringList(rawValues, new ConfigurationUtils.Key("packagingExcludes"), Collections.emptyList()));
        excludes.addAll(ConfigurationUtils.valueAsStringList(rawValues, new ConfigurationUtils.Key("warSourceExcludes"), Collections.emptyList()));
        this.excludes = excludes.toArray(new String[0]);
        ArrayList<String> includes = new ArrayList<String>();
        includes.addAll(ConfigurationUtils.valueAsStringList(rawValues, new ConfigurationUtils.Key("includes", "include"), Arrays.asList("**/**")));
        includes.addAll(ConfigurationUtils.valueAsStringList(rawValues, new ConfigurationUtils.Key("packagingIncludes"), Collections.emptyList()));
        includes.addAll(ConfigurationUtils.valueAsStringList(rawValues, new ConfigurationUtils.Key("warSourceIncludes"), Collections.emptyList()));
        this.includes = includes.toArray(new String[0]);
    }

    public File getWarSourceDirectory() {
        return this.warSourceDirectory;
    }

    @Override
    public String[] getIncludes() {
        return this.includes;
    }

    @Override
    public String[] getExcludes() {
        return this.excludes;
    }

    @Override
    public String getPluginGA() {
        return WAR_PLUGIN_GA;
    }
}

