/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.impl.webcommon30;

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.webcommon30.ServletMappingType;
import org.jboss.shrinkwrap.descriptor.spi.node.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletMappingTypeImpl<T>
implements Child<T>,
ServletMappingType<T> {
    private T t;
    private Node childNode;

    public ServletMappingTypeImpl(T t, String nodeName, Node node) {
        this.t = t;
        this.childNode = node.createChild(nodeName);
    }

    public ServletMappingTypeImpl(T t, String nodeName, Node node, Node childNode) {
        this.t = t;
        this.childNode = childNode;
    }

    public T up() {
        return this.t;
    }

    public ServletMappingType<T> servletName(String servletName) {
        this.childNode.getOrCreate("servlet-name").text(servletName);
        return this;
    }

    public String getServletName() {
        return this.childNode.getTextValueForPatternName("servlet-name");
    }

    public ServletMappingType<T> removeServletName() {
        this.childNode.removeChildren("servlet-name");
        return this;
    }

    public ServletMappingType<T> urlPattern(String ... values) {
        if (values != null) {
            for (String name : values) {
                this.childNode.createChild("url-pattern").text(name);
            }
        }
        return this;
    }

    public List<String> getAllUrlPattern() {
        ArrayList<String> result = new ArrayList<String>();
        List nodes = this.childNode.get("url-pattern");
        for (Node node : nodes) {
            result.add(node.getText());
        }
        return result;
    }

    public ServletMappingType<T> removeAllUrlPattern() {
        this.childNode.removeChildren("url-pattern");
        return this;
    }
}

