/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.impl.persistence10;

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.persistence10.Persistence;
import org.jboss.shrinkwrap.descriptor.api.persistence10.PersistenceUnit;
import org.jboss.shrinkwrap.descriptor.impl.persistence10.PersistenceUnitImpl;
import org.jboss.shrinkwrap.descriptor.spi.node.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceImpl<T>
implements Child<T>,
Persistence<T> {
    private T t;
    private Node childNode;

    public PersistenceImpl(T t, String nodeName, Node node) {
        this.t = t;
        this.childNode = node.createChild(nodeName);
    }

    public PersistenceImpl(T t, String nodeName, Node node, Node childNode) {
        this.t = t;
        this.childNode = childNode;
    }

    public T up() {
        return this.t;
    }

    public PersistenceUnit<Persistence<T>> getOrCreatePersistenceUnit() {
        List nodeList = this.childNode.get("persistence-unit");
        if (nodeList != null && nodeList.size() > 1) {
            return new PersistenceUnitImpl<Persistence<T>>(this, "persistence-unit", this.childNode, (Node)nodeList.get(0));
        }
        return this.createPersistenceUnit();
    }

    public PersistenceUnit<Persistence<T>> createPersistenceUnit() {
        return new PersistenceUnitImpl<Persistence<T>>(this, "persistence-unit", this.childNode);
    }

    public List<PersistenceUnit<Persistence<T>>> getAllPersistenceUnit() {
        ArrayList<PersistenceUnit<Persistence<T>>> list = new ArrayList<PersistenceUnit<Persistence<T>>>();
        List nodeList = this.childNode.get("persistence-unit");
        for (Node node : nodeList) {
            PersistenceUnitImpl<PersistenceImpl> type = new PersistenceUnitImpl<PersistenceImpl>(this, "persistence-unit", this.childNode, node);
            list.add(type);
        }
        return list;
    }

    public Persistence<T> removeAllPersistenceUnit() {
        this.childNode.removeChildren("persistence-unit");
        return this;
    }

    public Persistence<T> version(String version) {
        this.childNode.attribute("version", version);
        return this;
    }

    public String getVersion() {
        return this.childNode.getAttribute("version");
    }

    public Persistence<T> removeVersion() {
        this.childNode.removeAttribute("version");
        return this;
    }
}

