/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.utils;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.BigDecimalHolder;
import javax.xml.rpc.holders.BigIntegerHolder;
import javax.xml.rpc.holders.BooleanHolder;
import javax.xml.rpc.holders.BooleanWrapperHolder;
import javax.xml.rpc.holders.ByteArrayHolder;
import javax.xml.rpc.holders.ByteHolder;
import javax.xml.rpc.holders.ByteWrapperHolder;
import javax.xml.rpc.holders.CalendarHolder;
import javax.xml.rpc.holders.DoubleHolder;
import javax.xml.rpc.holders.DoubleWrapperHolder;
import javax.xml.rpc.holders.FloatHolder;
import javax.xml.rpc.holders.FloatWrapperHolder;
import javax.xml.rpc.holders.IntHolder;
import javax.xml.rpc.holders.IntegerWrapperHolder;
import javax.xml.rpc.holders.LongHolder;
import javax.xml.rpc.holders.LongWrapperHolder;
import javax.xml.rpc.holders.ObjectHolder;
import javax.xml.rpc.holders.QNameHolder;
import javax.xml.rpc.holders.ShortHolder;
import javax.xml.rpc.holders.ShortWrapperHolder;
import javax.xml.rpc.holders.StringHolder;
import javax.xml.ws.Holder;
import org.jboss.logging.Logger;
import org.jboss.wsf.common.JavaUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HolderUtils {
    private static final Logger log = Logger.getLogger(HolderUtils.class);

    public static boolean isHolderType(Class javaType) {
        return javax.xml.rpc.holders.Holder.class.isAssignableFrom(javaType) || Holder.class.isAssignableFrom(javaType);
    }

    public static boolean isHolderType(Type javaType) {
        return HolderUtils.isHolderType(JavaUtils.erasure((Type)javaType));
    }

    public static Class getJAXRPCHolderType(Class valueType) {
        if (valueType == null) {
            throw new IllegalArgumentException("Illegal null parameter");
        }
        if (javax.xml.rpc.holders.Holder.class.isAssignableFrom(valueType)) {
            throw new IllegalArgumentException("Is already a holder: " + valueType.getName());
        }
        if (valueType == BigDecimal.class) {
            return BigDecimalHolder.class;
        }
        if (valueType == BigInteger.class) {
            return BigIntegerHolder.class;
        }
        if (valueType == Boolean.TYPE) {
            return BooleanHolder.class;
        }
        if (valueType == Boolean.class) {
            return BooleanWrapperHolder.class;
        }
        if (valueType == byte[].class) {
            return ByteArrayHolder.class;
        }
        if (valueType == Byte.TYPE) {
            return ByteHolder.class;
        }
        if (valueType == Byte.class) {
            return ByteWrapperHolder.class;
        }
        if (valueType == Calendar.class) {
            return CalendarHolder.class;
        }
        if (valueType == Double.TYPE) {
            return DoubleHolder.class;
        }
        if (valueType == Double.class) {
            return DoubleWrapperHolder.class;
        }
        if (valueType == Float.TYPE) {
            return FloatHolder.class;
        }
        if (valueType == Float.class) {
            return FloatWrapperHolder.class;
        }
        if (valueType == Integer.TYPE) {
            return IntHolder.class;
        }
        if (valueType == Integer.class) {
            return IntegerWrapperHolder.class;
        }
        if (valueType == Long.TYPE) {
            return LongHolder.class;
        }
        if (valueType == Long.class) {
            return LongWrapperHolder.class;
        }
        if (valueType == QName.class) {
            return QNameHolder.class;
        }
        if (valueType == Short.TYPE) {
            return ShortHolder.class;
        }
        if (valueType == Short.class) {
            return ShortWrapperHolder.class;
        }
        if (valueType == String.class) {
            return StringHolder.class;
        }
        if (valueType == Object.class) {
            return ObjectHolder.class;
        }
        log.warn("Cannot get holder type for: " + valueType);
        return null;
    }

    public static Class getValueType(Type holderType) {
        Field field;
        Class holderClass = JavaUtils.erasure((Type)holderType);
        boolean jaxrpcHolder = javax.xml.rpc.holders.Holder.class.isAssignableFrom(holderClass);
        boolean jaxwsHolder = Holder.class.isAssignableFrom(holderClass);
        if (!jaxrpcHolder && !jaxwsHolder) {
            throw new IllegalArgumentException("Is not a holder: " + holderClass.getName());
        }
        if (jaxwsHolder) {
            return JavaUtils.erasure((Type)HolderUtils.getGenericValueType(holderType));
        }
        try {
            field = holderClass.getField("value");
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("Cannot find public value field: " + holderClass);
        }
        return field.getType();
    }

    public static Class getValueType(Class holderClass) {
        Field field;
        boolean jaxrpcHolder = javax.xml.rpc.holders.Holder.class.isAssignableFrom(holderClass);
        boolean jaxwsHolder = Holder.class.isAssignableFrom(holderClass);
        if (!jaxrpcHolder && !jaxwsHolder) {
            throw new IllegalArgumentException("Is not a holder: " + holderClass.getName());
        }
        if (jaxwsHolder) {
            return Object.class;
        }
        try {
            field = holderClass.getField("value");
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("Cannot find public value field: " + holderClass);
        }
        return field.getType();
    }

    public static Object getHolderValue(Object holder) {
        if (holder == null) {
            throw new IllegalArgumentException("Illegal null parameter");
        }
        if (!javax.xml.rpc.holders.Holder.class.isInstance(holder) && !Holder.class.isInstance(holder)) {
            throw new IllegalArgumentException("Is not a holder: " + holder);
        }
        try {
            Field valueField = holder.getClass().getField("value");
            Object obj = valueField.get(holder);
            return obj;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot access public value field: " + holder);
        }
    }

    public static void setHolderValue(Object holder, Object value) {
        if (holder == null) {
            throw new IllegalArgumentException("Holder instance was null");
        }
        if (!javax.xml.rpc.holders.Holder.class.isInstance(holder) && !Holder.class.isInstance(holder)) {
            throw new IllegalArgumentException("Is not a holder: " + holder);
        }
        Class valueType = HolderUtils.getValueType(holder.getClass());
        if (value != null && !JavaUtils.isAssignableFrom((Class)valueType, value.getClass())) {
            throw new IllegalArgumentException("Holder [" + holder.getClass().getName() + "] value not assignable: " + value);
        }
        if (valueType.isArray()) {
            value = JavaUtils.syncArray((Object)value, (Class)valueType);
        }
        try {
            Field valueField = holder.getClass().getField("value");
            if (value != null || !valueType.isPrimitive()) {
                valueField.set(holder, value);
            }
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot access public value field: " + holder);
        }
    }

    public static Type getGenericValueType(Type holder) {
        if (holder instanceof ParameterizedType) {
            return ((ParameterizedType)holder).getActualTypeArguments()[0];
        }
        return Object.class;
    }

    public static Object createHolderInstance(Object value, Class<?> holderType) {
        Object holder;
        if (!HolderUtils.isHolderType(holderType)) {
            throw new IllegalArgumentException("Not a holder type:" + holderType.getName());
        }
        try {
            holder = holderType.newInstance();
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot instanciate holder: " + holderType);
        }
        HolderUtils.setHolderValue(holder, value);
        return holder;
    }
}

