/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc.handler;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.rpc.handler.MessageContext;
import org.jboss.logging.Logger;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.binding.SerializationContext;
import org.jboss.ws.core.jaxrpc.SerializationContextJAXRPC;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.xb.binding.NamespaceRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MessageContextJAXRPC
extends CommonMessageContext
implements MessageContext {
    private static Logger log = Logger.getLogger(MessageContextJAXRPC.class);
    public static final String SERVLET_CONTEXT = "javax.xml.ws.servlet.context";
    public static final String SERVLET_REQUEST = "javax.xml.ws.servlet.request";
    public static final String SERVLET_RESPONSE = "javax.xml.ws.servlet.response";

    public MessageContextJAXRPC() {
    }

    public MessageContextJAXRPC(CommonMessageContext msgContext) {
        super(msgContext);
    }

    @Override
    public SerializationContext createSerializationContext() {
        EndpointMetaData epMetaData = this.getEndpointMetaData();
        ServiceMetaData serviceMetaData = epMetaData.getServiceMetaData();
        SerializationContextJAXRPC jaxrpcContext = new SerializationContextJAXRPC();
        jaxrpcContext.setTypeMapping(serviceMetaData.getTypeMapping());
        jaxrpcContext.setJavaWsdlMapping(serviceMetaData.getJavaWsdlMapping());
        return jaxrpcContext;
    }

    @Override
    public NamespaceRegistry getNamespaceRegistry() {
        return this.getSerializationContext().getNamespaceRegistry();
    }

    public static CommonMessageContext processPivot(CommonMessageContext requestContext) {
        log.debug("Begin response processing");
        MessageContextJAXRPC.cleanupAttachments(requestContext);
        return requestContext;
    }

    public Map<String, Object> getProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (String key : this.keySet()) {
            Object value = this.get(key);
            props.put(key, value);
        }
        return props;
    }

    @Override
    public boolean containsProperty(String name) {
        return this.containsKey(name);
    }

    @Override
    public Object getProperty(String name) {
        return this.get(name);
    }

    @Override
    public Iterator getPropertyNames() {
        return this.keySet().iterator();
    }

    @Override
    public void removeProperty(String name) {
        this.remove(name);
    }

    @Override
    public void setProperty(String name, Object value) {
        this.put(name, value);
    }
}

