/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.deployers;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractTopLevelClassLoaderDeployer;
import org.jboss.deployers.structure.spi.DeploymentContext;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentContext;
import org.jboss.deployers.vfs.spi.structure.helpers.ClassPathVisitor;
import org.jboss.mx.loading.LoaderRepositoryFactory;
import org.jboss.mx.loading.RepositoryClassLoader;
import org.jboss.system.ServiceController;
import org.jboss.system.metadata.ServiceDeployment;
import org.jboss.virtual.VirtualFile;

public class ServiceClassLoaderDeployer
extends AbstractTopLevelClassLoaderDeployer {
    private final ServiceController controller;

    public ServiceClassLoaderDeployer(ServiceController controller) {
        if (controller == null) {
            throw new IllegalArgumentException("Null controller");
        }
        this.controller = controller;
    }

    public ClassLoader createTopLevelClassLoader(DeploymentContext context) throws Exception {
        LoaderRepositoryFactory.LoaderRepositoryConfig loaderConfig;
        MBeanServer server = this.controller.getMBeanServer();
        DeploymentUnit unit = context.getDeploymentUnit();
        VirtualFile root = null;
        URL url = null;
        if (context instanceof VFSDeploymentContext) {
            VFSDeploymentContext vfsContext = (VFSDeploymentContext)context;
            root = vfsContext.getRoot();
            try {
                if (root != null) {
                    url = this.trimJARURL(root.toURL());
                }
            }
            catch (Exception ignored) {
                this.log.debug("Unable to get URL for " + context.getName() + " reason=" + ignored);
            }
        }
        if ((loaderConfig = unit.getAttachment(LoaderRepositoryFactory.LoaderRepositoryConfig.class)) != null) {
            this.log.debug("Using loader repository config: " + loaderConfig.repositoryName);
        }
        if (loaderConfig == null) {
            loaderConfig = new LoaderRepositoryFactory.LoaderRepositoryConfig();
            unit.addAttachment(LoaderRepositoryFactory.LoaderRepositoryConfig.class, loaderConfig);
            this.log.trace("Using default loader repository config: " + loaderConfig.repositoryName);
        }
        LoaderRepositoryFactory.createLoaderRepository(server, loaderConfig);
        Object[] args = new Object[]{url, url, Boolean.TRUE};
        String[] sig = new String[]{"java.net.URL", "java.net.URL", "boolean"};
        RepositoryClassLoader ucl = (RepositoryClassLoader)server.invoke(loaderConfig.repositoryName, "newClassLoader", args, sig);
        try {
            ClassPathVisitor visitor = new ClassPathVisitor();
            context.visit(visitor);
            Set<VirtualFile> classpath = visitor.getClassPath();
            for (VirtualFile path : classpath) {
                if (path == root) continue;
                ucl.addURL(this.trimJARURL(path.toURL()));
            }
            ObjectName uclName = ucl.getObjectName();
            if (!server.isRegistered(uclName)) {
                server.registerMBean(ucl, uclName);
            }
        }
        catch (Throwable t) {
            this.internalRemoveClassLoader(context, ucl);
            throw DeploymentException.rethrowAsDeploymentException("Error creating classloader: " + context.getName(), t);
        }
        return ucl;
    }

    public void removeTopLevelClassLoader(DeploymentContext context) {
        RepositoryClassLoader ucl = (RepositoryClassLoader)context.getClassLoader();
        if (ucl == null) {
            return;
        }
        this.internalRemoveClassLoader(context, ucl);
    }

    private void internalRemoveClassLoader(DeploymentContext context, RepositoryClassLoader ucl) {
        MBeanServer server = this.controller.getMBeanServer();
        try {
            ObjectName uclName = ucl.getObjectName();
            if (server.isRegistered(uclName)) {
                server.unregisterMBean(uclName);
            }
        }
        catch (Throwable t) {
            this.log.warn("Error unregistering classloader mbean: " + ucl + " for " + context.getName(), t);
        }
        try {
            ucl.unregister();
        }
        catch (Throwable t) {
            this.log.warn("Error unregistering ucl: " + ucl + " for " + context.getName(), t);
        }
        try {
            LoaderRepositoryFactory.LoaderRepositoryConfig config;
            DeploymentUnit unit = context.getDeploymentUnit();
            ServiceDeployment deployment = unit.getAttachment(ServiceDeployment.class);
            if (deployment != null && (config = unit.getAttachment(LoaderRepositoryFactory.LoaderRepositoryConfig.class)) != null) {
                LoaderRepositoryFactory.destroyLoaderRepository(server, config.repositoryName);
            }
        }
        catch (Throwable t) {
            this.log.warn("Error removing classloader from repository: " + ucl + " for " + context.getName(), t);
        }
    }

    private URL trimJARURL(URL url) throws MalformedURLException {
        String temp = url.toString();
        if (temp.startsWith("jar:") && temp.endsWith("!/")) {
            temp = temp.substring(4, temp.length() - 2);
            return new URL(temp);
        }
        return url;
    }
}

